/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.passthroughsigns.util;

import com.girafi.passthroughsigns.api.IPassable;
import com.girafi.passthroughsigns.api.PassthroughSignsAPI;
import com.girafi.passthroughsigns.util.ConfigurationHandler;
import com.girafi.passthroughsigns.util.PassableHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="passthroughsigns")
public class PassableHandler {
    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Player player = event.getEntity();
        Block block = state.m_60734_();
        if (block instanceof WallSignBlock && (Boolean)ConfigurationHandler.GENERAL.shouldWallSignBePassable.get() != false || block instanceof WallBannerBlock && (Boolean)ConfigurationHandler.GENERAL.shouldBannerBePassable.get() != false || block instanceof IPassable && ((IPassable)block).canBePassed(level, pos, IPassable.EnumPassableType.WALL_BLOCK) || PassthroughSignsAPI.BLOCK_PASSABLES.contains(block)) {
            Direction facingOpposite = Direction.NORTH.m_122424_();
            if (state.m_61138_((Property)DirectionalBlock.f_52588_)) {
                facingOpposite = ((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122424_();
            } else if (state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
                facingOpposite = ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
            }
            if (block instanceof WallSignBlock) {
                if (!player.m_6047_()) {
                    PassableHelper.rightClick(level, pos, player, event.getHand(), facingOpposite);
                    event.setCanceled(true);
                }
            } else if (!player.m_6047_()) {
                PassableHelper.rightClick(level, pos, player, event.getHand(), facingOpposite);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        if (entity instanceof ItemFrame && (Boolean)ConfigurationHandler.GENERAL.shouldItemFrameBePassable.get() != false || entity instanceof Painting && (Boolean)ConfigurationHandler.GENERAL.shouldPaintingsBePassable.get() != false || entity instanceof IPassable && ((IPassable)entity).canBePassed(level, pos, IPassable.EnumPassableType.HANGING_ENTITY) || PassthroughSignsAPI.ENTITY_PASSABLES.contains(entity.m_6095_())) {
            Direction facingOpposite = entity.m_6350_().m_122424_();
            if (!player.m_6047_()) {
                if (entity instanceof ItemFrame && ((Boolean)ConfigurationHandler.GENERAL.turnOffItemRotation.get()).booleanValue() && level.m_8055_(pos.m_121945_(facingOpposite)).m_155947_()) {
                    event.setCanceled(true);
                }
                PassableHelper.rightClick(level, pos, player, event.getHand(), facingOpposite);
            }
        }
    }
}

