package com.girafi.passthroughsigns.api;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class PassthroughSignsAPI {
    public static IPassable passable;
    public static final Set<class_2248> BLOCK_PASSABLES = new HashSet<>();
    public static final Set<class_1299<?>> ENTITY_PASSABLES = new HashSet<>();

    /**
     * Can be used to make a block/entity based on its registry name from string passable
     * Example of use of intermod communication : InterModComms.sendTo("passthroughsigns", "registerPassable", "block/entity registry name");
     *
     * @param string the string of a blocks registry name or an entities class string
     */
    public static void setCanBePassed(String string) {
        class_2960 identifier = class_2960.method_60654(string);
        if (class_7923.field_41177.method_10250(identifier)) {
            ENTITY_PASSABLES.add(class_7923.field_41177.method_63535(identifier));
        } else if (class_7923.field_41175.method_10250(identifier)) {
            BLOCK_PASSABLES.add(class_7923.field_41175.method_63535(identifier));
        }
    }

    /**
     * Convenience method for making a block passable
     *
     * @param block the block
     **/
    public static void setCanBePassed(class_2248 block) {
        BLOCK_PASSABLES.add(block);
    }

    /**
     * Convenience method for making an entity passable
     *
     * @param entityType the entity type
     **/
    public static void setCanBePassed(class_1299<?> entityType) {
        ENTITY_PASSABLES.add(entityType);
    }
}