/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.passthroughsigns.util;

import com.girafi.passthroughsigns.api.IPassable;
import com.girafi.passthroughsigns.api.PassthroughSignsAPI;
import com.girafi.passthroughsigns.util.ConfigurationHandler;
import com.girafi.passthroughsigns.util.PassableHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.painting.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="passthroughsigns")
public class PassableHandler {
    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Player player = event.getEntity();
        Block block = state.getBlock();
        ItemStack heldStack = player.getMainHandItem();
        InteractionHand hand = event.getHand();
        if (hand == InteractionHand.MAIN_HAND && (block instanceof WallSignBlock && (Boolean)ConfigurationHandler.GENERAL.shouldWallSignBePassable.get() != false || block instanceof WallBannerBlock && (Boolean)ConfigurationHandler.GENERAL.shouldBannerBePassable.get() != false || block instanceof IPassable && ((IPassable)block).canBePassed(level, pos, IPassable.EnumPassableType.WALL_BLOCK) || PassthroughSignsAPI.BLOCK_PASSABLES.contains(block)) && !(heldStack.getItem() instanceof SignApplicator)) {
            Direction facingOpposite = Direction.NORTH.getOpposite();
            if (state.hasProperty((Property)DirectionalBlock.FACING)) {
                facingOpposite = ((Direction)state.getValue((Property)DirectionalBlock.FACING)).getOpposite();
            } else if (state.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
                facingOpposite = ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite();
            }
            BlockPos posOffset = pos.offset(facingOpposite.getStepX(), facingOpposite.getStepY(), facingOpposite.getStepZ());
            BlockState attachedState = level.getBlockState(posOffset);
            BlockHitResult rayTrace = new BlockHitResult(new Vec3((double)posOffset.getX(), (double)posOffset.getY(), (double)posOffset.getZ()), facingOpposite, posOffset, false);
            if (block instanceof WallSignBlock) {
                if (!player.isCrouching()) {
                    PassableHelper.rightClick(level, pos, attachedState, player, rayTrace);
                    if (attachedState.getBlock() instanceof BaseEntityBlock) {
                        event.setCanceled(true);
                    }
                }
            } else if (!player.isCrouching()) {
                PassableHelper.rightClick(level, pos, attachedState, player, rayTrace);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        if (entity instanceof ItemFrame && (Boolean)ConfigurationHandler.GENERAL.shouldItemFrameBePassable.get() != false || entity instanceof Painting && (Boolean)ConfigurationHandler.GENERAL.shouldPaintingsBePassable.get() != false || entity instanceof IPassable && ((IPassable)entity).canBePassed(level, pos, IPassable.EnumPassableType.HANGING_ENTITY) || PassthroughSignsAPI.ENTITY_PASSABLES.contains(entity.getType())) {
            Direction facingOpposite = entity.getDirection().getOpposite();
            if (!player.isCrouching()) {
                if (entity instanceof ItemFrame && ((Boolean)ConfigurationHandler.GENERAL.turnOffItemRotation.get()).booleanValue() && level.getBlockState(pos.relative(facingOpposite)).hasBlockEntity()) {
                    event.setCanceled(true);
                }
                PassableHelper.rightClick(level, pos, player, facingOpposite);
            }
        }
    }
}

