/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.block.blockentity;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;

public abstract class IItemHandlerBEBase
extends BlockEntity
implements Nameable {
    private Component customName;
    public final ItemStacksResourceHandler handler = this.createItemHandler();

    public IItemHandlerBEBase(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Nonnull
    protected abstract ItemStacksResourceHandler createItemHandler();

    protected void loadAdditional(@Nonnull ValueInput input) {
        super.loadAdditional(input);
        input.child("inv").ifPresent(child -> this.handler.deserialize(child));
        this.customName = IItemHandlerBEBase.parseCustomNameSafe((ValueInput)input, (String)"CustomName");
    }

    protected void saveAdditional(@Nonnull ValueOutput output) {
        super.saveAdditional(output);
        output.putChild("inv", (ValueIOSerializable)this.handler);
        output.storeNullable("CustomName", ComponentSerialization.CODEC, (Object)this.customName);
    }

    @Nonnull
    public Component getName() {
        return this.customName != null ? this.customName : Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @Nonnull
    public Component getDisplayName() {
        return this.getName();
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }
}

