/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.model;

import com.teammetallurgy.aquaculture.client.renderer.blockentity.state.TackleBoxRenderState;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;

public class TackleBoxModel
extends Model<TackleBoxRenderState> {
    private final ModelPart base;
    private final ModelPart lid;

    public TackleBoxModel(ModelPart root) {
        super(root, RenderType::entityCutout);
        this.base = root.getChild("base");
        this.lid = root.getChild("lid");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition lid = partDefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -3.0f, -8.0f, 14.0f, 3.0f, 8.0f), PartPose.offset((float)7.0f, (float)12.0f, (float)4.0f));
        partDefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 11).addBox(0.0f, -6.0f, -8.0f, 14.0f, 6.0f, 8.0f), PartPose.offset((float)0.0f, (float)18.0f, (float)4.0f));
        lid.addOrReplaceChild("handle", CubeListBuilder.create().texOffs(36, 0).addBox(-2.0f, -4.0f, -5.0f, 4.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void setupAnim(TackleBoxRenderState renderState) {
        float openness = renderState.openness;
        openness = 1.0f - openness;
        openness = 1.0f - openness * openness * openness;
        this.lid.xRot = -(openness * 1.5707964f);
    }
}

