/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teammetallurgy.aquaculture.block.TackleBoxBlock;
import com.teammetallurgy.aquaculture.block.blockentity.TackleBoxBlockEntity;
import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.client.model.TackleBoxModel;
import com.teammetallurgy.aquaculture.client.renderer.blockentity.state.TackleBoxRenderState;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import javax.annotation.Nonnull;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class TackleBoxRenderer<T extends TackleBoxBlockEntity>
implements BlockEntityRenderer<T, TackleBoxRenderState> {
    public static final ResourceLocation TACKLE_BOX_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/block/tackle_box.png");
    public final TackleBoxModel tackleBoxModel;

    public TackleBoxRenderer(BlockEntityRendererProvider.Context context) {
        this.tackleBoxModel = new TackleBoxModel(context.bakeLayer(ClientHandler.TACKLE_BOX));
    }

    @Nonnull
    public TackleBoxRenderState createRenderState() {
        return new TackleBoxRenderState();
    }

    public void extractRenderState(@Nonnull T tackleBox, @Nonnull TackleBoxRenderState renderState, float partialTick, @Nonnull Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState(tackleBox, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        boolean hasLevel = tackleBox.getLevel() != null;
        BlockState blockstate = hasLevel ? tackleBox.getBlockState() : (BlockState)((Block)AquaBlocks.TACKLE_BOX.get()).defaultBlockState().setValue(TackleBoxBlock.FACING, (Comparable)Direction.SOUTH);
        renderState.angle = ((Direction)blockstate.getValue(TackleBoxBlock.FACING)).toYRot();
        renderState.openness = ((TackleBoxBlockEntity)((Object)tackleBox)).getOpenNess(partialTick);
    }

    public void submit(TackleBoxRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, @Nonnull CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-renderState.angle));
        poseStack.translate(-0.5, -0.5, -0.5);
        poseStack.translate(0.0625f, 1.125f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(-180.0f));
        this.tackleBoxModel.setupAnim(renderState);
        nodeCollector.submitModel((Model)this.tackleBoxModel, (Object)renderState, poseStack, RenderType.entityCutout((ResourceLocation)TACKLE_BOX_TEXTURE), renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, null, 0, renderState.breakProgress);
        poseStack.popPose();
    }
}

