/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teammetallurgy.aquaculture.client.renderer.entity.state.AquaBobberRenderState;
import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.FishingHookRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class AquaFishingHookRenderer
extends EntityRenderer<AquaFishingBobberEntity, AquaBobberRenderState> {
    private static final ResourceLocation BOBBER = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/bobber/bobber.png");
    private static final ResourceLocation BOBBER_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/bobber/bobber_overlay.png");
    private static final ResourceLocation BOBBER_VANILLA = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/bobber/bobber_vanilla.png");
    private static final ResourceLocation HOOK = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/hook/hook.png");
    private static final RenderType BOBBER_RENDER = RenderType.entityCutout((ResourceLocation)BOBBER);
    private static final RenderType BOBBER_OVERLAY_RENDER = RenderType.entityCutout((ResourceLocation)BOBBER_OVERLAY);
    private static final RenderType BOBBER_VANILLA_RENDER = RenderType.entityCutout((ResourceLocation)BOBBER_VANILLA);
    private static final RenderType HOOK_RENDER = RenderType.entityCutout((ResourceLocation)HOOK);

    public AquaFishingHookRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRender(@Nonnull AquaFishingBobberEntity bobber, @Nonnull Frustum frustum, double x, double y, double z) {
        return super.shouldRender((Entity)bobber, frustum, x, y, z) && bobber.getPlayerOwner() != null;
    }

    public void submit(@Nonnull AquaBobberRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)cameraRenderState.orientation);
        nodeCollector.submitCustomGeometry(poseStack, renderState.hasBobber ? BOBBER_OVERLAY_RENDER : BOBBER_VANILLA_RENDER, (pose, vertexConsumer) -> {
            ItemStack bobberStack = renderState.bobber;
            float bobberR = 1.0f;
            float bobberG = 1.0f;
            float bobberB = 1.0f;
            int bobberColorInt = ARGB.color((int)193, (int)38, (int)38);
            if (!bobberStack.isEmpty() && bobberStack.is(ItemTags.DYEABLE)) {
                DyedItemColor dyeditemcolor = (DyedItemColor)bobberStack.get(DataComponents.DYED_COLOR);
                if (dyeditemcolor != null) {
                    bobberColorInt = dyeditemcolor.rgb();
                }
                bobberR = (float)(bobberColorInt >> 16 & 0xFF) / 255.0f;
                bobberG = (float)(bobberColorInt >> 8 & 0xFF) / 255.0f;
                bobberB = (float)(bobberColorInt & 0xFF) / 255.0f;
            }
            AquaFishingHookRenderer.vertex(vertexConsumer, pose, renderState.lightCoords, 0.0f, 0, 0, 1, bobberR, bobberG, bobberB);
            AquaFishingHookRenderer.vertex(vertexConsumer, pose, renderState.lightCoords, 1.0f, 0, 1, 1, bobberR, bobberG, bobberB);
            AquaFishingHookRenderer.vertex(vertexConsumer, pose, renderState.lightCoords, 1.0f, 1, 1, 0, bobberR, bobberG, bobberB);
            AquaFishingHookRenderer.vertex(vertexConsumer, pose, renderState.lightCoords, 0.0f, 1, 0, 0, bobberR, bobberG, bobberB);
        });
        nodeCollector.submitCustomGeometry(poseStack, BOBBER_RENDER, (pose, vertexConsumer) -> {
            if (renderState.hasBobber) {
                AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 0.0f, 0, 0, 1);
                AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 1.0f, 0, 1, 1);
                AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 1.0f, 1, 1, 0);
                AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 0.0f, 1, 0, 0);
            }
        });
        nodeCollector.submitCustomGeometry(poseStack, renderState.hasHook ? RenderType.entityCutout((ResourceLocation)renderState.hook.getTexture()) : HOOK_RENDER, (pose, vertexConsumer) -> {
            AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 0.0f, 0, 0, 1);
            AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 1.0f, 0, 1, 1);
            AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 1.0f, 1, 1, 0);
            AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 0.0f, 1, 0, 0);
        });
        poseStack.popPose();
        float x = (float)renderState.lineOriginOffset.x;
        float y = (float)renderState.lineOriginOffset.y;
        float z = (float)renderState.lineOriginOffset.z;
        nodeCollector.submitCustomGeometry(poseStack, RenderType.lineStrip(), (pose, vertexConsumer) -> {
            DyedItemColor dyeditemcolor;
            ItemStack line = renderState.fishingLine;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (!line.isEmpty() && line.is(ItemTags.DYEABLE) && (dyeditemcolor = (DyedItemColor)line.get(DataComponents.DYED_COLOR)) != null) {
                int colorInt = dyeditemcolor.rgb();
                r = (float)(colorInt >> 16 & 0xFF) / 255.0f;
                g = (float)(colorInt >> 8 & 0xFF) / 255.0f;
                b = (float)(colorInt & 0xFF) / 255.0f;
            }
            for (int size = 0; size < 16; ++size) {
                float sizeFraction = AquaFishingHookRenderer.fraction(size, 16);
                float sizeFraction1 = AquaFishingHookRenderer.fraction(size + 1, 16);
                AquaFishingHookRenderer.stringVertex(x, y, z, vertexConsumer, pose, sizeFraction, sizeFraction1, r, g, b);
                AquaFishingHookRenderer.stringVertex(x, y, z, vertexConsumer, pose, sizeFraction1, sizeFraction, r, g, b);
            }
        });
        poseStack.popPose();
        super.submit((EntityRenderState)renderState, poseStack, nodeCollector, cameraRenderState);
    }

    private static void renderPosTexture(VertexConsumer builder, PoseStack.Pose pose, int packedLight, float x, int y, int u, int v) {
        builder.addVertex(pose, x - 0.5f, (float)y - 0.5f, 0.0f).setColor(255, 255, 255, 255).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
    }

    private static void vertex(VertexConsumer builder, PoseStack.Pose pose, int packedLight, float x, int y, int u, int v, float r, float g, float b) {
        builder.addVertex(pose, x - 0.5f, (float)y - 0.5f, 0.0f).setColor(r, g, b, 1.0f).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
    }

    private static void stringVertex(float x, float y, float z, VertexConsumer vertexConsumer, PoseStack.Pose pose, float f1, float f2, float r, float g, float b) {
        float var7 = x * f1;
        float var8 = y * (f1 * f1 + f1) * 0.5f + 0.25f;
        float var9 = z * f1;
        float var10 = x * f2 - var7;
        float var11 = y * (f2 * f2 + f2) * 0.5f + 0.25f - var8;
        float var12 = z * f2 - var9;
        float var13 = Mth.sqrt((float)(var10 * var10 + var11 * var11 + var12 * var12));
        vertexConsumer.addVertex(pose.pose(), var7, var8, var9).setColor(r, g, b, 1.0f).setNormal(pose, var10 /= var13, var11 /= var13, var12 /= var13);
    }

    private static float fraction(int numerator, int denominator) {
        return (float)numerator / (float)denominator;
    }

    private Vec3 getPlayerHandPos(Player player, float handAngle, float partialTick) {
        int i;
        int n = i = FishingHookRenderer.getHoldingArm((Player)player) == HumanoidArm.RIGHT ? 1 : -1;
        if (this.entityRenderDispatcher.options.getCameraType().isFirstPerson() && player == Minecraft.getInstance().player) {
            double d4 = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
            Vec3 vec3 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)i * 0.525f, -0.1f).scale(d4).yRot(handAngle * 0.5f).xRot(-handAngle * 0.7f);
            return player.getEyePosition(partialTick).add(vec3);
        }
        float f = Mth.lerp((float)partialTick, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
        double d0 = Mth.sin((float)f);
        double d1 = Mth.cos((float)f);
        float f1 = player.getScale();
        double d2 = (double)i * 0.35 * (double)f1;
        double d3 = 0.8 * (double)f1;
        float f2 = player.isCrouching() ? -0.1875f : 0.0f;
        return player.getEyePosition(partialTick).add(-d1 * d2 - d0 * d3, (double)f2 - 0.45 * (double)f1, -d0 * d2 + d1 * d3);
    }

    @Nonnull
    public AquaBobberRenderState createRenderState() {
        return new AquaBobberRenderState();
    }

    public void extractRenderState(@Nonnull AquaFishingBobberEntity bobber, @Nonnull AquaBobberRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)bobber, (EntityRenderState)reusedState, partialTick);
        Player player = bobber.getPlayerOwner();
        if (player == null) {
            reusedState.lineOriginOffset = Vec3.ZERO;
        } else {
            float attackAnim = player.getAttackAnim(partialTick);
            float f1 = Mth.sin((float)(Mth.sqrt((float)attackAnim) * (float)Math.PI));
            Vec3 vec3 = this.getPlayerHandPos(player, f1, partialTick);
            Vec3 vec31 = bobber.getPosition(partialTick).add(0.0, 0.25, 0.0);
            reusedState.lineOriginOffset = vec3.subtract(vec31);
        }
        reusedState.hasBobber = bobber.hasBobber();
        reusedState.hasHook = bobber.hasHook();
        reusedState.bobber = bobber.getBobber();
        reusedState.fishingLine = bobber.getFishingLine();
        reusedState.hook = bobber.getHook();
    }

    protected boolean affectedByCulling(@Nonnull AquaFishingBobberEntity bobber) {
        return false;
    }
}

