/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.client.model.NeptunesBountyModel;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Vector3f;

public class NeptunesBountySpecialRenderer
implements NoDataSpecialModelRenderer {
    public static final ResourceLocation NEPTUNES_BOUNTY = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/block/neptunes_bounty.png");
    private final NeptunesBountyModel model;
    private final float openness;

    public NeptunesBountySpecialRenderer(NeptunesBountyModel model, float openness) {
        this.model = model;
        this.openness = openness;
    }

    public void submit(@Nonnull ItemDisplayContext displayContext, @Nonnull PoseStack poseStack, @Nonnull SubmitNodeCollector nodeCollector, int packedLight, int packedOverlay, boolean hasFoil, int outlineColor) {
        nodeCollector.submitModel((Model)this.model, (Object)Float.valueOf(this.openness), poseStack, this.model.renderType(NEPTUNES_BOUNTY), packedLight, packedOverlay, -1, null, outlineColor, null);
    }

    public void getExtents(Set<Vector3f> output) {
        PoseStack posestack = new PoseStack();
        this.model.setupAnim(this.openness);
        this.model.root().getExtentsForGui(posestack, output);
    }

    public record Unbaked(float openness) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(m -> m.group((App)Codec.FLOAT.optionalFieldOf("openness", (Object)Float.valueOf(0.0f)).forGetter(Unbaked::openness)).apply((Applicative)m, Unbaked::new));

        public Unbaked(ResourceLocation location) {
            this(0.0f);
        }

        @Nonnull
        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(@Nonnull SpecialModelRenderer.BakingContext context) {
            NeptunesBountyModel neptunesBountyModel = new NeptunesBountyModel(context.entityModelSet().bakeLayer(ClientHandler.NEPTUNES_BOUNTY));
            return new NeptunesBountySpecialRenderer(neptunesBountyModel, this.openness);
        }
    }
}

