/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.inventory.container;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.api.bait.IBaitItem;
import com.teammetallurgy.aquaculture.init.AquaDataComponents;
import com.teammetallurgy.aquaculture.inventory.container.slot.SlotFishingRod;
import com.teammetallurgy.aquaculture.item.HookItem;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;

public class FishingRodContainerWrapper
implements Container {
    private final SlotFishingRod rodSlot;
    private final int actualSlots;
    private ItemStacksResourceHandler tackleBox;

    public FishingRodContainerWrapper(SlotFishingRod rodSlot, int actualSlots, ItemStacksResourceHandler tackleBox) {
        this.rodSlot = rodSlot;
        this.actualSlots = actualSlots;
        this.tackleBox = tackleBox;
    }

    private ItemStack rod() {
        return this.rodSlot.getRod();
    }

    @Nullable
    private ItemContainerContents inv() {
        ItemStack rod = this.rod();
        return rod.isEmpty() ? null : (ItemContainerContents)rod.get(AquaDataComponents.ROD_INVENTORY);
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean canPlaceItem(int slot, @Nonnull ItemStack stack) {
        return switch (slot) {
            case 0 -> stack.getItem() instanceof HookItem;
            case 1 -> stack.getItem() instanceof IBaitItem;
            case 2 -> stack.is(AquacultureAPI.Tags.FISHING_LINE);
            case 3 -> stack.is(AquacultureAPI.Tags.BOBBER);
            default -> false;
        };
    }

    public int getContainerSize() {
        return this.actualSlots;
    }

    public boolean isEmpty() {
        ItemContainerContents inv = this.inv();
        if (inv == null) {
            return true;
        }
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack getItem(int slot) {
        ItemContainerContents inv = this.inv();
        if (inv == null) {
            return ItemStack.EMPTY;
        }
        return slot < inv.getSlots() ? inv.getStackInSlot(slot) : ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack removeItem(int slot, int count) {
        if (this.inv() == null) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = this.getItem(slot);
        if (count >= existing.getCount()) {
            this.setItem(slot, ItemStack.EMPTY);
        } else {
            ItemStack remaining = existing.copy();
            existing = existing.split(count);
            this.setItem(slot, remaining);
        }
        return existing;
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int slot) {
        if (this.inv() == null) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = this.getItem(slot);
        this.setItem(slot, ItemStack.EMPTY);
        return existing;
    }

    public void setItem(int slot, @Nonnull ItemStack newStack) {
        ItemStack rod = this.rod();
        if (rod.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(this.actualSlots);
        ItemContainerContents inv = this.inv();
        for (int i = 0; i < this.actualSlots; ++i) {
            ItemStack existing = inv != null && i < inv.getSlots() ? inv.getStackInSlot(i) : ItemStack.EMPTY;
            items.add(i == slot ? newStack : existing);
        }
        ItemContainerContents newInv = ItemContainerContents.fromItems(items);
        rod.set(AquaDataComponents.ROD_INVENTORY, (Object)newInv);
        this.tackleBox.set(0, (Resource)ItemResource.of((ItemStack)rod), 1);
    }

    public void setChanged() {
    }

    public boolean stillValid(@Nonnull Player player) {
        return this.inv() != null;
    }

    public void clearContent() {
        this.rod().remove(AquaDataComponents.ROD_INVENTORY);
        this.tackleBox.set(0, (Resource)ItemResource.EMPTY, 0);
    }
}

