/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item.neptunium;

import com.teammetallurgy.aquaculture.init.AquaDataComponents;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.block.state.BlockState;

public class NeptuniumPickaxe
extends Item {
    public NeptuniumPickaxe(ToolMaterial toolMaterial, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(properties.pickaxe(toolMaterial, attackDamage, attackSpeed));
    }

    public void inventoryTick(@Nonnull ItemStack stack, @Nonnull ServerLevel level, @Nonnull Entity entity, @Nonnull EquipmentSlot slot) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.getItem() == this) {
                stack.set(AquaDataComponents.IN_WATER, (Object)player.isEyeInFluid(FluidTags.WATER));
            }
        }
    }

    public float getDestroySpeed(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        float defaultSpeed = super.getDestroySpeed(stack, state);
        Boolean inWater = (Boolean)stack.get(AquaDataComponents.IN_WATER);
        boolean isInWater = stack.has(AquaDataComponents.IN_WATER) && inWater != null && inWater != false;
        return isInWater ? defaultSpeed * 5.0f * 5.0f : defaultSpeed;
    }
}

