/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client;

import com.teammetallurgy.aquaculture.client.gui.screen.TackleBoxScreen;
import com.teammetallurgy.aquaculture.client.model.NeptunesBountyModel;
import com.teammetallurgy.aquaculture.client.model.TackleBoxModel;
import com.teammetallurgy.aquaculture.client.renderer.blockentity.NeptunesBountyRenderer;
import com.teammetallurgy.aquaculture.client.renderer.blockentity.TackleBoxRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.AquaFishRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.AquaFishingHookRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.FishMountRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.TurtleLandRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.AquaTropicalFishBModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishCathfishModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLargeModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLongnoseModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishMediumModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishSmallModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.JellyfishModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.TurtleLandModel;
import com.teammetallurgy.aquaculture.client.renderer.special.NeptunesBountySpecialRenderer;
import com.teammetallurgy.aquaculture.client.renderer.special.TackleBoxSpecialRenderer;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.init.AquaBlockEntities;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import com.teammetallurgy.aquaculture.init.AquaGuis;
import com.teammetallurgy.aquaculture.init.FishRegistry;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.SpectralArrowRenderer;
import net.minecraft.client.renderer.entity.TippableArrowRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterSpecialBlockModelRendererEvent;
import net.neoforged.neoforge.client.event.RegisterSpecialModelRendererEvent;
import net.neoforged.neoforge.client.model.standalone.SimpleUnbakedStandaloneModel;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.model.standalone.UnbakedStandaloneModel;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="aquaculture", value={Dist.CLIENT})
public class ClientHandler {
    public static final ModelLayerLocation NEPTUNES_BOUNTY = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"neptunes_bounty"), "neptunes_bounty");
    public static final ModelLayerLocation TACKLE_BOX = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"tackle_box"), "tackle_box");
    public static final ModelLayerLocation TURTLE_LAND_LAYER = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"turtle_land"), "turtle_land");
    public static final ModelLayerLocation TURTLE_LAND_BABY_LAYER = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"turtle_land"), "turtle_land_baby");
    public static final ModelLayerLocation SMALL_MODEL = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"small_model"), "small_model");
    public static final ModelLayerLocation MEDIUM_MODEL = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"medium_model"), "medium_model");
    public static final ModelLayerLocation LARGE_MODEL = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"large_model"), "large_model");
    public static final ModelLayerLocation LONGNOSE_MODEL = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"longnose_model"), "longnose_model");
    public static final ModelLayerLocation CATFISH_MODEL = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"catfish_model"), "catfish_model");
    public static final ModelLayerLocation TROPICAL_FISH_B = new ModelLayerLocation(ModelLayers.TROPICAL_FISH_SMALL.model(), "tropical_fish_b");
    public static final ModelLayerLocation JELLYFISH_MODEL = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"jellyfish_model"), "jellyfish_model");
    public static final Identifier OAK_FISH_MOUNT = Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"block/oak_fish_mount");
    public static final Identifier SPRUCE_FISH_MOUNT = Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"block/spruce_fish_mount");
    public static final Identifier BIRCH_FISH_MOUNT = Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"block/birch_fish_mount");
    public static final Identifier JUNGLE_FISH_MOUNT = Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"block/jungle_fish_mount");
    public static final Identifier ACACIA_FISH_MOUNT = Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"block/acacia_fish_mount");
    public static final Identifier DARK_OAK_FISH_MOUNT = Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"block/dark_oak_fish_mount");
    public static final StandaloneModelKey<BlockStateModel> OAK_FISH_MOUNT_KEY = new StandaloneModelKey(() -> "aquaculture: Oak Fish Mount");
    public static final StandaloneModelKey<BlockStateModel> SPRUCE_FISH_MOUNT_KEY = new StandaloneModelKey(() -> "aquaculture: Spruce Fish Mount");
    public static final StandaloneModelKey<BlockStateModel> BIRCH_FISH_MOUNT_KEY = new StandaloneModelKey(() -> "aquaculture: Birch Fish Mount");
    public static final StandaloneModelKey<BlockStateModel> JUNGLE_FISH_MOUNT_KEY = new StandaloneModelKey(() -> "aquaculture: Jungle Fish Mount");
    public static final StandaloneModelKey<BlockStateModel> ACACIA_FISH_MOUNT_KEY = new StandaloneModelKey(() -> "aquaculture: Acacia Fish Mount");
    public static final StandaloneModelKey<BlockStateModel> DARK_OAK_FISH_MOUNT_KEY = new StandaloneModelKey(() -> "aquaculture: Dark Oak Fish Mount");

    public static void setupClient() {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)AquaBlockEntities.NEPTUNES_BOUNTY.get()), NeptunesBountyRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)AquaBlockEntities.TACKLE_BOX.get()), TackleBoxRenderer::new);
    }

    @SubscribeEvent
    public static void registerSpecialBlockModelRenderer(RegisterSpecialBlockModelRendererEvent event) {
        event.register((Block)AquaBlocks.NEPTUNES_BOUNTY.get(), (SpecialModelRenderer.Unbaked)new NeptunesBountySpecialRenderer.Unbaked(NeptunesBountySpecialRenderer.NEPTUNES_BOUNTY));
        event.register((Block)AquaBlocks.TACKLE_BOX.get(), (SpecialModelRenderer.Unbaked)new TackleBoxSpecialRenderer.Unbaked());
    }

    @SubscribeEvent
    public static void registerSpecialModelRenderers(RegisterSpecialModelRendererEvent event) {
        event.register(Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"neptunes_bounty"), NeptunesBountySpecialRenderer.Unbaked.MAP_CODEC);
        event.register(Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"tackle_box"), TackleBoxSpecialRenderer.Unbaked.MAP_CODEC);
    }

    @SubscribeEvent
    public static void registerMenuScreen(RegisterMenuScreensEvent event) {
        event.register((MenuType)AquaGuis.TACKLE_BOX.get(), TackleBoxScreen::new);
    }

    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)AquaEntities.BOBBER.get(), AquaFishingHookRenderer::new);
        for (DeferredHolder<EntityType<?>, EntityType<AquaFishEntity>> deferredHolder : FishRegistry.fishEntities) {
            event.registerEntityRenderer((EntityType)deferredHolder.get(), AquaFishRenderer::new);
        }
        event.registerEntityRenderer((EntityType)AquaEntities.WATER_ARROW.get(), TippableArrowRenderer::new);
        event.registerEntityRenderer((EntityType)AquaEntities.SPECTRAL_WATER_ARROW.get(), SpectralArrowRenderer::new);
        event.registerEntityRenderer((EntityType)AquaEntities.BOX_TURTLE.get(), TurtleLandRenderer::new);
        event.registerEntityRenderer((EntityType)AquaEntities.ARRAU_TURTLE.get(), TurtleLandRenderer::new);
        event.registerEntityRenderer((EntityType)AquaEntities.STARSHELL_TURTLE.get(), TurtleLandRenderer::new);
        for (DeferredHolder deferredHolder : FishRegistry.fishMounts) {
            event.registerEntityRenderer((EntityType)deferredHolder.get(), FishMountRenderer::new);
        }
    }

    @SubscribeEvent
    public static void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(NEPTUNES_BOUNTY, NeptunesBountyModel::createSingleBodyLayer);
        event.registerLayerDefinition(TACKLE_BOX, TackleBoxModel::createLayer);
        event.registerLayerDefinition(TURTLE_LAND_LAYER, TurtleLandModel::createBodyLayer);
        event.registerLayerDefinition(TURTLE_LAND_BABY_LAYER, () -> TurtleLandModel.createBodyLayer().apply(TurtleLandModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(SMALL_MODEL, FishSmallModel::createBodyLayer);
        event.registerLayerDefinition(MEDIUM_MODEL, FishMediumModel::createBodyLayer);
        event.registerLayerDefinition(LARGE_MODEL, FishLargeModel::createBodyLayer);
        event.registerLayerDefinition(LONGNOSE_MODEL, FishLongnoseModel::createBodyLayer);
        event.registerLayerDefinition(CATFISH_MODEL, FishCathfishModel::createBodyLayer);
        event.registerLayerDefinition(TROPICAL_FISH_B, () -> AquaTropicalFishBModel.createBodyLayer(CubeDeformation.NONE));
        event.registerLayerDefinition(JELLYFISH_MODEL, JellyfishModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterStandalone event) {
        event.register(OAK_FISH_MOUNT_KEY, (UnbakedStandaloneModel)SimpleUnbakedStandaloneModel.blockStateModel((Identifier)OAK_FISH_MOUNT));
        event.register(SPRUCE_FISH_MOUNT_KEY, (UnbakedStandaloneModel)SimpleUnbakedStandaloneModel.blockStateModel((Identifier)SPRUCE_FISH_MOUNT));
        event.register(BIRCH_FISH_MOUNT_KEY, (UnbakedStandaloneModel)SimpleUnbakedStandaloneModel.blockStateModel((Identifier)BIRCH_FISH_MOUNT));
        event.register(JUNGLE_FISH_MOUNT_KEY, (UnbakedStandaloneModel)SimpleUnbakedStandaloneModel.blockStateModel((Identifier)JUNGLE_FISH_MOUNT));
        event.register(ACACIA_FISH_MOUNT_KEY, (UnbakedStandaloneModel)SimpleUnbakedStandaloneModel.blockStateModel((Identifier)ACACIA_FISH_MOUNT));
        event.register(DARK_OAK_FISH_MOUNT_KEY, (UnbakedStandaloneModel)SimpleUnbakedStandaloneModel.blockStateModel((Identifier)DARK_OAK_FISH_MOUNT));
    }
}

