/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.gui.screen;

import com.teammetallurgy.aquaculture.inventory.container.TackleBoxContainer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TackleBoxScreen
extends AbstractContainerScreen<TackleBoxContainer> {
    private static final Identifier TACKLE_BOX_GUI = Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"textures/gui/container/tackle_box.png");

    public TackleBoxScreen(TackleBoxContainer tackleBoxContainer, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)tackleBoxContainer, playerInventory, title);
        this.imageHeight = 172;
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 100, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 4, 0x404040, false);
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderSlot(x, y, 0, 0, this.imageWidth, this.imageHeight, guiGraphics);
        if (((TackleBoxContainer)this.menu).slotHook != null && ((TackleBoxContainer)this.menu).slotHook.isActive()) {
            if (((TackleBoxContainer)this.menu).slotHook.hasItem()) {
                this.renderEmptySlot(x + 105, y + 43, guiGraphics);
            } else {
                this.renderSlot(x + 105, y + 43, 176, 0, 18, 18, guiGraphics);
            }
            if (((TackleBoxContainer)this.menu).slotBait.hasItem()) {
                this.renderEmptySlot(x + 128, y + 43, guiGraphics);
            } else {
                this.renderSlot(x + 128, y + 43, 176, 18, 18, 18, guiGraphics);
            }
            if (((TackleBoxContainer)this.menu).slotLine.hasItem()) {
                this.renderEmptySlot(x + 105, y + 66, guiGraphics);
            } else {
                this.renderSlot(x + 105, y + 66, 176, 36, 18, 18, guiGraphics);
            }
            if (((TackleBoxContainer)this.menu).slotBobber.hasItem()) {
                this.renderEmptySlot(x + 128, y + 66, guiGraphics);
            } else {
                this.renderSlot(x + 128, y + 66, 176, 54, 18, 18, guiGraphics);
            }
        }
    }

    private void renderSlot(int x, int y, int uOffset, int vOffset, int uWidth, int vHeight, GuiGraphics guiGraphics) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TACKLE_BOX_GUI, x, y, (float)uOffset, (float)vOffset, uWidth, vHeight, 256, 256);
    }

    private void renderEmptySlot(int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TACKLE_BOX_GUI, x, y, 7.0f, 7.0f, 18, 18, 256, 256);
    }
}

