/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teammetallurgy.aquaculture.client.renderer.entity.state.AquaFishingHookRenderState;
import com.teammetallurgy.aquaculture.entity.AquaFishingHookEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.FishingHookRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class AquaFishingHookRenderer
extends EntityRenderer<AquaFishingHookEntity, AquaFishingHookRenderState> {
    private static final Identifier BOBBER = Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/bobber/bobber.png");
    private static final Identifier BOBBER_OVERLAY = Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/bobber/bobber_overlay.png");
    private static final Identifier BOBBER_VANILLA = Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/bobber/bobber_vanilla.png");
    private static final Identifier HOOK = Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/hook/hook.png");
    private static final RenderType BOBBER_RENDER = RenderTypes.entityCutout((Identifier)BOBBER);
    private static final RenderType BOBBER_OVERLAY_RENDER = RenderTypes.entityCutout((Identifier)BOBBER_OVERLAY);
    private static final RenderType BOBBER_VANILLA_RENDER = RenderTypes.entityCutout((Identifier)BOBBER_VANILLA);
    private static final RenderType HOOK_RENDER = RenderTypes.entityCutout((Identifier)HOOK);

    public AquaFishingHookRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRender(@Nonnull AquaFishingHookEntity bobber, @Nonnull Frustum frustum, double x, double y, double z) {
        return super.shouldRender((Entity)bobber, frustum, x, y, z) && bobber.getPlayerOwner() != null;
    }

    public void submit(@Nonnull AquaFishingHookRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)cameraRenderState.orientation);
        nodeCollector.submitCustomGeometry(poseStack, renderState.hasBobber ? BOBBER_OVERLAY_RENDER : BOBBER_VANILLA_RENDER, (pose, vertexConsumer) -> {
            ItemStack bobberStack = renderState.bobber;
            float bobberR = 1.0f;
            float bobberG = 1.0f;
            float bobberB = 1.0f;
            int bobberColorInt = ARGB.color((int)193, (int)38, (int)38);
            if (!bobberStack.isEmpty() && bobberStack.is(ItemTags.DYEABLE)) {
                DyedItemColor dyeditemcolor = (DyedItemColor)bobberStack.get(DataComponents.DYED_COLOR);
                if (dyeditemcolor != null) {
                    bobberColorInt = dyeditemcolor.rgb();
                }
                bobberR = (float)(bobberColorInt >> 16 & 0xFF) / 255.0f;
                bobberG = (float)(bobberColorInt >> 8 & 0xFF) / 255.0f;
                bobberB = (float)(bobberColorInt & 0xFF) / 255.0f;
            }
            AquaFishingHookRenderer.vertex(vertexConsumer, pose, renderState.lightCoords, 0.0f, 0, 0, 1, bobberR, bobberG, bobberB);
            AquaFishingHookRenderer.vertex(vertexConsumer, pose, renderState.lightCoords, 1.0f, 0, 1, 1, bobberR, bobberG, bobberB);
            AquaFishingHookRenderer.vertex(vertexConsumer, pose, renderState.lightCoords, 1.0f, 1, 1, 0, bobberR, bobberG, bobberB);
            AquaFishingHookRenderer.vertex(vertexConsumer, pose, renderState.lightCoords, 0.0f, 1, 0, 0, bobberR, bobberG, bobberB);
        });
        nodeCollector.submitCustomGeometry(poseStack, BOBBER_RENDER, (pose, vertexConsumer) -> {
            if (renderState.hasBobber) {
                AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 0.0f, 0, 0, 1);
                AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 1.0f, 0, 1, 1);
                AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 1.0f, 1, 1, 0);
                AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 0.0f, 1, 0, 0);
            }
        });
        nodeCollector.submitCustomGeometry(poseStack, renderState.hasHook ? RenderTypes.entityCutout((Identifier)renderState.hook.getTexture()) : HOOK_RENDER, (pose, vertexConsumer) -> {
            AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 0.0f, 0, 0, 1);
            AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 1.0f, 0, 1, 1);
            AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 1.0f, 1, 1, 0);
            AquaFishingHookRenderer.renderPosTexture(vertexConsumer, pose, renderState.lightCoords, 0.0f, 1, 0, 0);
        });
        poseStack.popPose();
        float x = (float)renderState.lineOriginOffset.x;
        float y = (float)renderState.lineOriginOffset.y;
        float z = (float)renderState.lineOriginOffset.z;
        float width = Minecraft.getInstance().getWindow().getAppropriateLineWidth();
        nodeCollector.submitCustomGeometry(poseStack, RenderTypes.lines(), (pose, vertexConsumer) -> {
            DyedItemColor dyeditemcolor;
            ItemStack line = renderState.fishingLine;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (!line.isEmpty() && line.is(ItemTags.DYEABLE) && (dyeditemcolor = (DyedItemColor)line.get(DataComponents.DYED_COLOR)) != null) {
                int colorInt = dyeditemcolor.rgb();
                r = (float)(colorInt >> 16 & 0xFF) / 255.0f;
                g = (float)(colorInt >> 8 & 0xFF) / 255.0f;
                b = (float)(colorInt & 0xFF) / 255.0f;
            }
            for (int size = 0; size < 16; ++size) {
                float sizeFraction = AquaFishingHookRenderer.fraction(size, 16);
                float sizeFraction1 = AquaFishingHookRenderer.fraction(size + 1, 16);
                AquaFishingHookRenderer.stringVertex(x, y, z, vertexConsumer, pose, sizeFraction, sizeFraction1, width, r, g, b);
                AquaFishingHookRenderer.stringVertex(x, y, z, vertexConsumer, pose, sizeFraction1, sizeFraction, width, r, g, b);
            }
        });
        poseStack.popPose();
        super.submit((EntityRenderState)renderState, poseStack, nodeCollector, cameraRenderState);
    }

    private static void renderPosTexture(VertexConsumer builder, PoseStack.Pose pose, int packedLight, float x, int y, int u, int v) {
        builder.addVertex(pose, x - 0.5f, (float)y - 0.5f, 0.0f).setColor(255, 255, 255, 255).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
    }

    private static void vertex(VertexConsumer builder, PoseStack.Pose pose, int packedLight, float x, int y, int u, int v, float r, float g, float b) {
        builder.addVertex(pose, x - 0.5f, (float)y - 0.5f, 0.0f).setColor(r, g, b, 1.0f).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
    }

    private static void stringVertex(float x, float y, float z, VertexConsumer consumer, PoseStack.Pose pose, float stringFraction, float nextStringFraction, float width, float r, float g, float b) {
        float f = x * stringFraction;
        float f1 = y * (stringFraction * stringFraction + stringFraction) * 0.5f + 0.25f;
        float f2 = z * stringFraction;
        float f3 = x * nextStringFraction - f;
        float f4 = y * (nextStringFraction * nextStringFraction + nextStringFraction) * 0.5f + 0.25f - f1;
        float f5 = z * nextStringFraction - f2;
        float f6 = Mth.sqrt((float)(f3 * f3 + f4 * f4 + f5 * f5));
        consumer.addVertex(pose, f, f1, f2).setColor(r, g, b, 1.0f).setNormal(pose, f3 /= f6, f4 /= f6, f5 /= f6).setLineWidth(width);
    }

    private static float fraction(int numerator, int denominator) {
        return (float)numerator / (float)denominator;
    }

    private Vec3 getPlayerHandPos(Player player, float handAngle, float partialTick) {
        int i;
        int n = i = FishingHookRenderer.getHoldingArm((Player)player) == HumanoidArm.RIGHT ? 1 : -1;
        if (this.entityRenderDispatcher.options.getCameraType().isFirstPerson() && player == Minecraft.getInstance().player) {
            double d4 = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
            Vec3 vec3 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)i * 0.525f, -0.1f).scale(d4).yRot(handAngle * 0.5f).xRot(-handAngle * 0.7f);
            return player.getEyePosition(partialTick).add(vec3);
        }
        float f = Mth.lerp((float)partialTick, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
        double d0 = Mth.sin((double)f);
        double d1 = Mth.cos((double)f);
        float f1 = player.getScale();
        double d2 = (double)i * 0.35 * (double)f1;
        double d3 = 0.8 * (double)f1;
        float f2 = player.isCrouching() ? -0.1875f : 0.0f;
        return player.getEyePosition(partialTick).add(-d1 * d2 - d0 * d3, (double)f2 - 0.45 * (double)f1, -d0 * d2 + d1 * d3);
    }

    @Nonnull
    public AquaFishingHookRenderState createRenderState() {
        return new AquaFishingHookRenderState();
    }

    public void extractRenderState(@Nonnull AquaFishingHookEntity bobber, @Nonnull AquaFishingHookRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)bobber, (EntityRenderState)reusedState, partialTick);
        Player player = bobber.getPlayerOwner();
        if (player == null) {
            reusedState.lineOriginOffset = Vec3.ZERO;
        } else {
            float attackAnim = player.getAttackAnim(partialTick);
            float f1 = Mth.sin((double)(Mth.sqrt((float)attackAnim) * (float)Math.PI));
            Vec3 vec3 = this.getPlayerHandPos(player, f1, partialTick);
            Vec3 vec31 = bobber.getPosition(partialTick).add(0.0, 0.25, 0.0);
            reusedState.lineOriginOffset = vec3.subtract(vec31);
        }
        reusedState.hasBobber = bobber.hasBobber();
        reusedState.hasHook = bobber.hasHook();
        reusedState.bobber = bobber.getBobber();
        reusedState.fishingLine = bobber.getFishingLine();
        reusedState.hook = bobber.getHook();
    }

    protected boolean affectedByCulling(@Nonnull AquaFishingHookEntity bobber) {
        return false;
    }
}

