/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.client.renderer.entity.state.FishMountRenderState;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishMountEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import com.teammetallurgy.aquaculture.init.AquaDataComponents;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.fish.Pufferfish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import org.joml.Quaternionfc;

public class FishMountRenderer<T extends FishMountEntity>
extends EntityRenderer<T, FishMountRenderState> {
    private final Minecraft mc = Minecraft.getInstance();

    public FishMountRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void submit(@Nonnull FishMountRenderState renderState, @Nonnull PoseStack poseStack, @Nonnull SubmitNodeCollector nodeCollector, @Nonnull CameraRenderState cameraRenderState) {
        float y;
        float x;
        super.submit((EntityRenderState)renderState, poseStack, nodeCollector, cameraRenderState);
        poseStack.pushPose();
        Direction direction = renderState.direction;
        Vec3 pos = this.getRenderOffset(renderState);
        poseStack.translate(-pos.x(), -pos.y(), -pos.z());
        double multiplier = 0.46875;
        poseStack.translate((double)direction.getStepX() * multiplier, (double)direction.getStepY() * multiplier, (double)direction.getStepZ() * multiplier);
        if (direction.getAxis().isHorizontal()) {
            x = 0.0f;
            y = 180.0f - direction.toYRot();
        } else {
            x = -90 * direction.getAxisDirection().getStep();
            y = 180.0f;
        }
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(x));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(y));
        if (!renderState.isInvisible) {
            BlockStateModel model;
            BlockRenderDispatcher rendererDispatcher = this.mc.getBlockRenderer();
            ModelManager manager = rendererDispatcher.getBlockModelShaper().getModelManager();
            poseStack.pushPose();
            poseStack.translate(-0.5, -0.5, -0.5);
            Identifier entityTypeID = renderState.byName;
            if (entityTypeID != null && (model = (BlockStateModel)manager.getStandaloneModel(this.getStandaloneKeyFromType(entityTypeID.getPath()))) != null) {
                nodeCollector.submitBlockModel(poseStack, RenderTypes.entitySolidZOffsetForward((Identifier)TextureAtlas.LOCATION_BLOCKS), model, 1.0f, 1.0f, 1.0f, renderState.lightCoords, OverlayTexture.NO_OVERLAY, renderState.outlineColor);
            }
            poseStack.popPose();
        }
        this.renderFish(renderState, poseStack, nodeCollector, cameraRenderState);
        poseStack.popPose();
    }

    private void renderFish(@Nonnull FishMountRenderState renderState, @Nonnull PoseStack poseStack, @Nonnull SubmitNodeCollector nodeCollector, @Nonnull CameraRenderState cameraRenderState) {
        Entity entity = renderState.mountedFish;
        if (entity instanceof Mob) {
            Mob fish = (Mob)entity;
            double x = 0.0;
            double y = 0.0;
            double depth = 0.42;
            if (fish instanceof Pufferfish) {
                depth += 0.09;
            } else if (fish instanceof AquaFishEntity && ((AquaFishEntity)fish).getFishType().equals((Object)FishType.LONGNOSE)) {
                x = -0.1f;
                y = -0.18;
            }
            fish.setNoAi(true);
            poseStack.translate(x, y, depth);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
            if (renderState.fishRenderState != null) {
                this.entityRenderDispatcher.submit(renderState.fishRenderState, cameraRenderState, 0.0, 0.0, 0.0, poseStack, nodeCollector);
            }
        }
    }

    @Nonnull
    public Vec3 getRenderOffset(FishMountRenderState fishMount) {
        return new Vec3((double)((float)fishMount.direction.getStepX() * 0.3f), -0.25, (double)((float)fishMount.direction.getStepZ() * 0.3f));
    }

    protected boolean shouldShowName(@Nonnull T fishMount, double distanceToCameraSq) {
        if (Minecraft.renderNames() && ((FishMountEntity)((Object)fishMount)).entity != null && this.mc.hitResult != null && fishMount.distanceToSqr(this.mc.hitResult.getLocation()) < 0.24) {
            double d0 = this.entityRenderDispatcher.distanceToSqr(fishMount);
            float sneaking = fishMount.isDiscrete() ? 32.0f : 64.0f;
            return d0 < (double)(sneaking * sneaking);
        }
        return false;
    }

    protected void submitNameTag(@Nonnull FishMountRenderState renderState, @Nonnull PoseStack poseStack, @Nonnull SubmitNodeCollector nodeCollector, @Nonnull CameraRenderState cameraRenderState) {
        if (renderState.mountedFish != null) {
            nodeCollector.submitNameTag(poseStack, renderState.nameTagAttachment, 0, renderState.mountedFish.getName(), !renderState.isDiscrete, renderState.lightCoords, renderState.distanceToCameraSq, cameraRenderState);
        }
        ItemStack stack = renderState.stack;
        Float fishWeight = (Float)stack.get((DataComponentType)AquaDataComponents.FISH_WEIGHT.get());
        if (stack.has(AquaDataComponents.FISH_WEIGHT) && fishWeight != null) {
            float weight = fishWeight.floatValue();
            String lb = (double)weight == 1.0 ? " lb" : " lbs";
            DecimalFormat df = new DecimalFormat("#,###.##");
            BigDecimal bd = new BigDecimal(weight);
            bd = bd.round(new MathContext(3));
            poseStack.pushPose();
            poseStack.translate(0.0, -0.25, 0.0);
            if (bd.doubleValue() > 999.0) {
                nodeCollector.submitNameTag(poseStack, renderState.nameTagAttachment, 0, (Component)Component.translatable((String)"aquaculture.fishWeight.weight", (Object[])new Object[]{df.format((int)bd.doubleValue()) + lb}), !renderState.isDiscrete, renderState.lightCoords, renderState.distanceToCameraSq, cameraRenderState);
            } else {
                nodeCollector.submitNameTag(poseStack, renderState.nameTagAttachment, 0, (Component)Component.translatable((String)"aquaculture.fishWeight.weight", (Object[])new Object[]{String.valueOf(bd) + lb}), !renderState.isDiscrete, renderState.lightCoords, renderState.distanceToCameraSq, cameraRenderState);
            }
            poseStack.popPose();
        }
    }

    @Nonnull
    public FishMountRenderState createRenderState() {
        return new FishMountRenderState();
    }

    public void extractRenderState(@Nonnull T entity, @Nonnull FishMountRenderState renderState, float partialTicks) {
        super.extractRenderState(entity, (EntityRenderState)renderState, partialTicks);
        renderState.direction = entity.getDirection();
        renderState.stack = ((FishMountEntity)((Object)entity)).getItem();
        renderState.byName = ((FishMountEntity)((Object)entity)).byName();
        renderState.mountedFish = ((FishMountEntity)((Object)entity)).entity;
        if (entity.level() != null && renderState.mountedFish != null) {
            renderState.fishRenderState = this.entityRenderDispatcher.extractEntity(renderState.mountedFish, 0.0f);
            renderState.fishRenderState.lightCoords = renderState.lightCoords;
        }
    }

    public StandaloneModelKey<BlockStateModel> getStandaloneKeyFromType(String mountType) {
        return switch (mountType) {
            case "spruce_fish_mount" -> ClientHandler.SPRUCE_FISH_MOUNT_KEY;
            case "birch_fish_mount" -> ClientHandler.BIRCH_FISH_MOUNT_KEY;
            case "jungle_fish_mount" -> ClientHandler.JUNGLE_FISH_MOUNT_KEY;
            case "acacia_fish_mount" -> ClientHandler.ACACIA_FISH_MOUNT_KEY;
            case "dark_oak_fish_mount" -> ClientHandler.DARK_OAK_FISH_MOUNT_KEY;
            default -> ClientHandler.OAK_FISH_MOUNT_KEY;
        };
    }
}

