/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.client.model.TackleBoxModel;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class TackleBoxSpecialRenderer
implements NoDataSpecialModelRenderer {
    public static final Identifier TACKLE_BOX = Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"textures/block/tackle_box.png");
    private final TackleBoxModel model;
    private final float openness;

    public TackleBoxSpecialRenderer(TackleBoxModel model, float openness) {
        this.model = model;
        this.openness = openness;
    }

    public void submit(@Nonnull ItemDisplayContext displayContext, @Nonnull PoseStack poseStack, @Nonnull SubmitNodeCollector nodeCollector, int packedLight, int packedOverlay, boolean hasFoil, int outlineColor) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-Direction.NORTH.toYRot()));
        poseStack.translate(-1.0f, 1.125f, -0.5f);
        poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(-180.0f));
        nodeCollector.submitModelPart(this.model.root(), poseStack, this.model.renderType(TACKLE_BOX), packedLight, packedOverlay, null, false, hasFoil, -1, null, outlineColor);
        poseStack.popPose();
    }

    public void getExtents(Consumer<Vector3fc> consumer) {
        PoseStack posestack = new PoseStack();
        this.model.root().getExtentsForGui(posestack, consumer);
    }

    public record Unbaked(float openness) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(r -> r.group((App)Codec.FLOAT.optionalFieldOf("angle", (Object)Float.valueOf(0.0f)).forGetter(Unbaked::openness)).apply((Applicative)r, Unbaked::new));

        public Unbaked() {
            this(0.0f);
        }

        @Nonnull
        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(@Nonnull SpecialModelRenderer.BakingContext context) {
            TackleBoxModel tackleBoxModel = new TackleBoxModel(context.entityModelSet().bakeLayer(ClientHandler.TACKLE_BOX));
            return new TackleBoxSpecialRenderer(tackleBoxModel, this.openness);
        }
    }
}

