/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.entity;

import com.teammetallurgy.aquaculture.entity.FishType;
import com.teammetallurgy.aquaculture.entity.ai.goal.FollowTypeSchoolLeaderGoal;
import com.teammetallurgy.aquaculture.init.AquaSounds;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.FollowFlockLeaderGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.fish.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="aquaculture")
public class AquaFishEntity
extends AbstractSchoolingFish {
    private final FishType fishType;

    public AquaFishEntity(EntityType<? extends AbstractSchoolingFish> entityType, Level world, FishType fishType) {
        super(entityType, world);
        this.fishType = fishType;
    }

    public FishType getFishType() {
        return this.fishType;
    }

    public Identifier byName() {
        return BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType());
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.availableGoals.forEach(prioritizedGoal -> {
            if (prioritizedGoal.getGoal().getClass() == FollowFlockLeaderGoal.class) {
                this.goalSelector.removeGoal(prioritizedGoal.getGoal());
            }
        });
        this.goalSelector.addGoal(5, (Goal)new FollowTypeSchoolLeaderGoal(this));
    }

    public ItemStack getPickResult() {
        return this.getBucketItemStack();
    }

    @Nonnull
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(Identifier.parse((String)(String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType())) + "_bucket"))));
    }

    @Nonnull
    protected SoundEvent getFlopSound() {
        if (this.getFishType() == FishType.JELLYFISH) {
            return (SoundEvent)AquaSounds.JELLYFISH_FLOP.get();
        }
        return (SoundEvent)AquaSounds.FISH_FLOP.get();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AquaSounds.FISH_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AquaSounds.FISH_DEATH.get();
    }

    protected SoundEvent getHurtSound(@Nonnull DamageSource damageSource) {
        return (SoundEvent)AquaSounds.FISH_HURT.get();
    }

    public void playerTouch(@Nonnull Player player) {
        Level level;
        super.playerTouch(player);
        if (Objects.equals(BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType()), Identifier.fromNamespaceAndPath((String)"aquaculture", (String)"jellyfish")) && this.isAlive() && (level = player.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.distanceToSqr((Entity)player) < 1.0 && player.hurtServer(level2, this.damageSources().mobAttack((LivingEntity)this), 0.5f)) {
                this.playSound((SoundEvent)AquaSounds.JELLYFISH_COLLIDE.get(), 0.5f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    public void stopFollowing() {
        if (this.leader != null) {
            super.stopFollowing();
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Entity target = event.getTarget();
        ItemStack handStack = event.getItemStack();
        Item item = handStack.getItem();
        if (!(item instanceof BucketItem)) {
            return;
        }
        BucketItem bucketItem = (BucketItem)item;
        if (bucketItem.content.isSame((Fluid)Fluids.WATER) && target instanceof AquaFishEntity) {
            CriteriaTriggers.FILLED_BUCKET.trigger(serverPlayer, new ItemStack((ItemLike)Items.COD_BUCKET));
        }
    }
}

