/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.EntitySubPredicate;
import net.minecraft.advancements.criterion.FishingHookPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;

@EventBusSubscriber(modid="aquaculture")
public class AquaLootTables {
    public static final ResourceKey<LootTable> BOX = AquaLootTables.register("box/box");
    public static final ResourceKey<LootTable> LOCKBOX = AquaLootTables.register("box/lockbox");
    public static final ResourceKey<LootTable> TREASURE_CHEST = AquaLootTables.register("box/treasure_chest");
    public static final ResourceKey<LootTable> NEPTUNES_BOUNTY = AquaLootTables.register("box/neptunes_bounty");
    public static final ResourceKey<LootTable> FISH = AquaLootTables.register("gameplay/fishing/fish");
    public static final ResourceKey<LootTable> JUNK = AquaLootTables.register("gameplay/fishing/junk");
    public static final ResourceKey<LootTable> NEPTUNIUM = AquaLootTables.register("gameplay/fishing/neptunium");
    public static final ResourceKey<LootTable> LAVA_FISHING = AquaLootTables.register("gameplay/fishing/lava/fishing");
    public static final ResourceKey<LootTable> LAVA_FISH = AquaLootTables.register("gameplay/fishing/lava/fish");
    public static final ResourceKey<LootTable> LAVA_JUNK = AquaLootTables.register("gameplay/fishing/lava/junk");
    public static final ResourceKey<LootTable> LAVA_TREASURE = AquaLootTables.register("gameplay/fishing/lava/treasure");
    public static final ResourceKey<LootTable> NETHER_FISHING = AquaLootTables.register("gameplay/fishing/nether/fishing");
    public static final ResourceKey<LootTable> NETHER_FISH = AquaLootTables.register("gameplay/fishing/nether/fish");
    public static final ResourceKey<LootTable> NETHER_JUNK = AquaLootTables.register("gameplay/fishing/nether/junk");
    public static final ResourceKey<LootTable> NETHER_TREASURE = AquaLootTables.register("gameplay/fishing/nether/treasure");

    private static ResourceKey<LootTable> register(String path) {
        return BuiltInLootTables.register((ResourceKey)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)Identifier.fromNamespaceAndPath((String)"aquaculture", (String)path)));
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        LootPool pool;
        Identifier name = event.getName();
        if (name != null && name.equals((Object)BuiltInLootTables.FISHING.identifier()) && (pool = event.getTable().getPool("main")) != null) {
            AquaLootTables.addEntry(pool, AquaLootTables.getInjectEntry(FISH, 85, -1));
            AquaLootTables.addEntry(pool, AquaLootTables.getInjectEntry(JUNK, 10, -2));
            if (((Boolean)AquaConfig.NEPTUNIUM_OPTIONS.addNeptunesBountyToLoot.get()).booleanValue()) {
                LootPoolEntryContainer neptuniumEntry = ((LootPoolSingletonContainer.Builder)NestedLootTable.lootTableReference(NEPTUNIUM).setWeight(((Integer)AquaConfig.NEPTUNIUM_OPTIONS.neptuniumLootRarity.get()).intValue()).setQuality(2).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)FishingHookPredicate.inOpenWater((boolean)true))))).build();
                AquaLootTables.addEntry(pool, neptuniumEntry);
            }
        }
    }

    private static LootPoolEntryContainer getInjectEntry(ResourceKey<LootTable> resourceKey, int weight, int quality) {
        return NestedLootTable.lootTableReference(resourceKey).setWeight(weight).setQuality(quality).build();
    }

    private static void addEntry(LootPool pool, LootPoolEntryContainer entry) {
        try {
            Field entries = LootPool.class.getDeclaredField("entries");
            entries.setAccessible(true);
            ArrayList lootPoolEntriesArray = new ArrayList(pool.entries);
            ArrayList<LootPoolEntryContainer> newLootEntries = new ArrayList<LootPoolEntryContainer>(lootPoolEntriesArray);
            if (newLootEntries.stream().anyMatch(e -> e == entry)) {
                throw new RuntimeException("Attempted to add a duplicate entry to pool: " + String.valueOf(entry));
            }
            newLootEntries.add(entry);
            entries.set(pool, newLootEntries);
        }
        catch (IllegalAccessException | NoSuchFieldException e2) {
            Aquaculture.LOG.error("Error occurred when attempting to add a new entry, to the fishing loot table");
            e2.printStackTrace();
        }
    }
}

