/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.integration.jei.recipes;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.init.AquaItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class FilletKnifeRecipeMaker {
    public static List<RecipeHolder<CraftingRecipe>> createFilletKnifeRecipes() {
        ArrayList<RecipeHolder<CraftingRecipe>> recipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
        for (Item fish : AquacultureAPI.FISH_DATA.getFish()) {
            TagKey<Item> filletKnifeTag = AquacultureAPI.Tags.KNIFE;
            NonNullList input = NonNullList.of((Object)Ingredient.of((ItemLike)Items.POTATO), (Object[])new Ingredient[]{Ingredient.of((HolderSet)HolderSet.emptyNamed((HolderOwner)BuiltInRegistries.ITEM, filletKnifeTag)), Ingredient.of((ItemLike)fish)});
            if (!AquacultureAPI.FISH_DATA.hasFilletAmount(fish)) continue;
            ItemStack output = new ItemStack((ItemLike)AquaItems.FISH_FILLET.get(), AquacultureAPI.FISH_DATA.getFilletAmount(fish));
            Identifier itemID = BuiltInRegistries.ITEM.getKey((Object)fish);
            if (itemID == null) continue;
            Identifier id = Identifier.fromNamespaceAndPath((String)"aquaculture", (String)("fish_fillet." + itemID.getPath()));
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)id);
            ShapelessRecipe recipe = new ShapelessRecipe("aquaculture.fish_fillet", CraftingBookCategory.MISC, output, (List)input);
            recipes.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(key, (Recipe)recipe));
        }
        return recipes;
    }
}

