/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.api.bait.IBaitItem;
import com.teammetallurgy.aquaculture.api.fishing.Hook;
import com.teammetallurgy.aquaculture.api.fishing.Hooks;
import com.teammetallurgy.aquaculture.entity.AquaFishingHookEntity;
import com.teammetallurgy.aquaculture.init.AquaDataComponents;
import com.teammetallurgy.aquaculture.item.HookItem;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.util.FakePlayer;

public class AquaFishingRodItem
extends FishingRodItem {
    private final ToolMaterial toolMaterial;

    public AquaFishingRodItem(ToolMaterial toolMaterial, Item.Properties properties) {
        super(properties.enchantable(toolMaterial == ToolMaterial.WOOD ? 10 : toolMaterial.enchantmentValue()).repairable(toolMaterial.repairItems()).component(AquaDataComponents.ROD_INVENTORY, (Object)ItemContainerContents.EMPTY));
        this.toolMaterial = toolMaterial;
    }

    public ToolMaterial getTier() {
        return this.toolMaterial;
    }

    public boolean isBarVisible(@Nonnull ItemStack stack) {
        return this.getDamage(stack) < this.getMaxDamage(stack) && super.isBarVisible(stack);
    }

    @Nonnull
    public InteractionResult use(@Nonnull Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (player instanceof FakePlayer) {
            return InteractionResult.FAIL;
        }
        boolean isAdminRod = (Boolean)AquaConfig.BASIC_OPTIONS.debugMode.get() != false && this.toolMaterial == AquacultureAPI.MATS.NEPTUNIUM;
        int damage = this.getDamage(heldStack);
        if (damage >= this.getMaxDamage(heldStack)) {
            return InteractionResult.FAIL;
        }
        Hook hook = AquaFishingRodItem.getHookType(heldStack);
        if (player.fishing != null) {
            if (!level.isClientSide()) {
                int currentDamage;
                int retrieve = player.fishing.retrieve(heldStack);
                if (retrieve >= (currentDamage = this.getMaxDamage(heldStack) - damage)) {
                    retrieve = currentDamage;
                }
                if (!isAdminRod) {
                    if (hook != Hooks.EMPTY && hook.getDurabilityChance() > 0.0) {
                        if (level.random.nextDouble() >= hook.getDurabilityChance()) {
                            heldStack.hurtAndBreak(retrieve, (LivingEntity)player, hand);
                        }
                    } else {
                        heldStack.hurtAndBreak(retrieve, (LivingEntity)player, hand);
                    }
                }
            }
            player.swing(hand);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
            if (level instanceof ServerLevel) {
                Item item;
                ServerLevel serverLevel = (ServerLevel)level;
                int lureSpeed = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)serverLevel, (ItemStack)heldStack, (Entity)player) * 20.0f);
                if (this.toolMaterial == AquacultureAPI.MATS.NEPTUNIUM) {
                    lureSpeed += 100;
                }
                ItemStack bait = AquaFishingRodItem.getBait(heldStack);
                if (!isAdminRod && !bait.isEmpty() && (item = bait.getItem()) instanceof IBaitItem) {
                    IBaitItem baitItem = (IBaitItem)item;
                    lureSpeed += baitItem.getLureSpeedModifier();
                }
                lureSpeed = Math.min(500, lureSpeed);
                int luck = EnchantmentHelper.getFishingLuckBonus((ServerLevel)serverLevel, (ItemStack)heldStack, (Entity)player);
                if (hook != Hooks.EMPTY && hook.getLuckModifier() > 0) {
                    luck += hook.getLuckModifier();
                }
                Projectile.spawnProjectile((Projectile)new AquaFishingHookEntity(player, level, luck, lureSpeed, hook, AquaFishingRodItem.getFishingLine(heldStack), AquaFishingRodItem.getBobber(heldStack), heldStack), (ServerLevel)serverLevel, (ItemStack)heldStack);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(heldStack);
    }

    public boolean canPerformAction(@Nonnull ItemStack stack, @Nonnull ItemAbility toolAction) {
        return ItemAbilities.DEFAULT_FISHING_ROD_ACTIONS.contains(toolAction);
    }

    @Nonnull
    public static Hook getHookType(@Nonnull ItemStack fishingRod) {
        ItemStack hookStack;
        Hook hook = Hooks.EMPTY;
        ItemContainerContents handler = AquaFishingRodItem.getHandler(fishingRod);
        if (handler != ItemContainerContents.EMPTY && (hookStack = handler.getStackInSlot(0)).getItem() instanceof HookItem) {
            hook = ((HookItem)hookStack.getItem()).getHookType();
        }
        return hook;
    }

    @Nonnull
    public static ItemStack getBait(@Nonnull ItemStack fishingRod) {
        ItemContainerContents handler = AquaFishingRodItem.getHandler(fishingRod);
        return handler != ItemContainerContents.EMPTY && handler.getSlots() > 1 ? handler.getStackInSlot(1) : ItemStack.EMPTY;
    }

    @Nonnull
    public static ItemStack getFishingLine(@Nonnull ItemStack fishingRod) {
        ItemContainerContents handler = AquaFishingRodItem.getHandler(fishingRod);
        return handler != ItemContainerContents.EMPTY & handler.getSlots() > 2 ? handler.getStackInSlot(2) : ItemStack.EMPTY;
    }

    @Nonnull
    public static ItemStack getBobber(@Nonnull ItemStack fishingRod) {
        ItemContainerContents handler = AquaFishingRodItem.getHandler(fishingRod);
        return handler != ItemContainerContents.EMPTY && handler.getSlots() > 3 ? handler.getStackInSlot(3) : ItemStack.EMPTY;
    }

    public static ItemContainerContents getHandler(@Nonnull ItemStack fishingRod) {
        return (ItemContainerContents)fishingRod.getOrDefault(AquaDataComponents.ROD_INVENTORY, (Object)ItemContainerContents.EMPTY);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, TooltipDisplay display, @Nonnull Consumer<Component> tooltips, @Nonnull TooltipFlag tooltipFlag) {
        Hook hook;
        if (this.getDamage(stack) >= this.getMaxDamage(stack)) {
            MutableComponent broken = Component.translatable((String)"aquaculture.fishing_rod.broken");
            tooltips.accept((Component)broken.withStyle(broken.getStyle().withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY)));
        }
        if ((hook = AquaFishingRodItem.getHookType(stack)) != Hooks.EMPTY) {
            MutableComponent hookColor = Component.translatable((String)hook.getItem().getDescriptionId());
            tooltips.accept((Component)hookColor.withStyle(hookColor.getStyle().withColor(hook.getColor())));
        }
    }
}

