/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.loot.BiomeTagPredicate;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class AquaBiomeModifiers {
    public static final DeferredRegister<MapCodec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS_DEFERRED = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"aquaculture");

    public record FishSpawnBiomeModifier(List<HolderSet<Biome>> includeBiomes, List<HolderSet<Biome>> excludeBiomes, boolean and, WeightedList<MobSpawnSettings.SpawnerData> spawners) implements BiomeModifier
    {
        public void modify(@Nonnull Holder<Biome> biome, @Nonnull BiomeModifier.Phase phase, @Nonnull ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD) {
                if (biome.tags().noneMatch(BiomeTagPredicate.INVALID_TYPES::contains)) {
                    MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
                    for (Weighted spawner : this.spawners.unwrap()) {
                        MobCategory category = ((MobSpawnSettings.SpawnerData)spawner.value()).type().getCategory();
                        if (((HolderSet)this.includeBiomes.stream().findAny().get()).stream().findAny().isEmpty() && !this.excludeBiomes.isEmpty()) {
                            for (HolderSet<Biome> exclude : this.excludeBiomes) {
                                if (!exclude.contains(biome)) continue;
                                return;
                            }
                            this.debugOutput(biome, "Exclude only. Valid biome included");
                            spawns.addSpawn(category, spawner.weight(), (MobSpawnSettings.SpawnerData)spawner.value());
                            continue;
                        }
                        if (this.and) {
                            for (HolderSet<Biome> include : this.includeBiomes) {
                                if (include.contains(biome)) continue;
                                return;
                            }
                            this.debugOutput(biome, "And Include");
                            spawns.addSpawn(category, spawner.weight(), (MobSpawnSettings.SpawnerData)spawner.value());
                            continue;
                        }
                        for (HolderSet<Biome> exclude : this.excludeBiomes) {
                            if (!exclude.contains(biome)) continue;
                            return;
                        }
                        for (HolderSet<Biome> include : this.includeBiomes) {
                            if (!include.contains(biome)) continue;
                            this.debugOutput(biome, "Normal");
                            spawns.addSpawn(category, spawner.weight(), (MobSpawnSettings.SpawnerData)spawner.value());
                        }
                    }
                }
            }
        }

        private void debugOutput(Holder<Biome> biomeHolder, String s) {
            if (((Boolean)AquaConfig.BASIC_OPTIONS.debugMode.get()).booleanValue()) {
                for (Weighted spawner : this.spawners.unwrap()) {
                    Aquaculture.LOG.info("Fish: " + String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey((Object)((MobSpawnSettings.SpawnerData)spawner.value()).type())) + " | " + s + ": " + String.valueOf(((ResourceKey)biomeHolder.unwrapKey().get()).identifier()));
                }
            }
        }

        @Nonnull
        public MapCodec<? extends BiomeModifier> codec() {
            return FishSpawnBiomeModifier.makeCodec();
        }

        public static MapCodec<FishSpawnBiomeModifier> makeCodec() {
            return RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.listOf().fieldOf("includeBiomes").forGetter(FishSpawnBiomeModifier::includeBiomes), (App)Biome.LIST_CODEC.listOf().fieldOf("excludeBiomes").forGetter(FishSpawnBiomeModifier::excludeBiomes), (App)Codec.BOOL.fieldOf("and").forGetter(FishSpawnBiomeModifier::and), (App)Codec.either((Codec)WeightedList.codec((MapCodec)MobSpawnSettings.SpawnerData.CODEC), (Codec)Weighted.codec((MapCodec)MobSpawnSettings.SpawnerData.CODEC)).xmap(either -> (WeightedList)either.map(Function.identity(), xva$0 -> WeightedList.of((Weighted[])new Weighted[]{xva$0})), list -> list.unwrap().size() == 1 ? Either.right((Object)((Weighted)list.unwrap().get(0))) : Either.left((Object)list)).fieldOf("spawn").forGetter(FishSpawnBiomeModifier::spawners)).apply((Applicative)builder, FishSpawnBiomeModifier::new));
        }
    }

    public record MobSpawnBiomeModifier(HolderSet<Biome> includeList, HolderSet<Biome> excludeList, WeightedList<MobSpawnSettings.SpawnerData> spawners) implements BiomeModifier
    {
        public void modify(@Nonnull Holder<Biome> biome, @Nonnull BiomeModifier.Phase phase, @Nonnull ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.includeList.contains(biome) && !this.excludeList.contains(biome)) {
                MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
                for (Weighted spawner : this.spawners.unwrap()) {
                    EntityType type = ((MobSpawnSettings.SpawnerData)spawner.value()).type();
                    spawns.addSpawn(type.getCategory(), spawner.weight(), (MobSpawnSettings.SpawnerData)spawner.value());
                }
            }
        }

        @Nonnull
        public MapCodec<? extends BiomeModifier> codec() {
            return MobSpawnBiomeModifier.makeCodec();
        }

        public static MapCodec<MobSpawnBiomeModifier> makeCodec() {
            return RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("includeBiomes").forGetter(MobSpawnBiomeModifier::includeList), (App)Biome.LIST_CODEC.fieldOf("excludeBiomes").forGetter(MobSpawnBiomeModifier::excludeList), (App)Codec.either((Codec)WeightedList.codec((MapCodec)MobSpawnSettings.SpawnerData.CODEC), (Codec)Weighted.codec((MapCodec)MobSpawnSettings.SpawnerData.CODEC)).xmap(either -> (WeightedList)either.map(Function.identity(), xva$0 -> WeightedList.of((Weighted[])new Weighted[]{xva$0})), list -> list.unwrap().size() == 1 ? Either.right((Object)((Weighted)list.unwrap().get(0))) : Either.left((Object)list)).fieldOf("spawn").forGetter(MobSpawnBiomeModifier::spawners)).apply((Applicative)builder, MobSpawnBiomeModifier::new));
        }
    }
}

