/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.api.fish.FishData;
import com.teammetallurgy.aquaculture.init.AquaDataComponents;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.StringUtils;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="aquaculture")
public class FishWeightHandler {
    @SubscribeEvent
    public static void onItemFished(ItemFishedEvent event) {
        if (!event.getDrops().isEmpty()) {
            ItemStack fish = (ItemStack)event.getDrops().get(0);
            if (((Boolean)AquaConfig.BASIC_OPTIONS.randomWeight.get()).booleanValue()) {
                if (AquacultureAPI.FISH_DATA.hasWeight(fish.getItem())) {
                    FishData fishWeight = AquacultureAPI.FISH_DATA;
                    FishWeightHandler.assignRandomWeight(fish, fishWeight.getMinWeight(fish.getItem()), fishWeight.getMaxWeight(fish.getItem()));
                } else if (fish.is(ItemTags.FISHES)) {
                    FishWeightHandler.assignRandomWeight(fish, 0.1, 100.0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.isEmpty() && stack != null && stack.has(AquaDataComponents.FISH_WEIGHT)) {
            Float fishWeight = (Float)stack.get(AquaDataComponents.FISH_WEIGHT);
            if (stack.has(AquaDataComponents.FISH_SIZE)) {
                MutableComponent fishWeightString = Component.translatable((String)("aquaculture.fishWeight." + StringUtils.toLowerCase((String)((String)stack.get(AquaDataComponents.FISH_SIZE)))));
                event.getToolTip().add(fishWeightString.withStyle(fishWeightString.getStyle().withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.AQUA)));
            }
            if (fishWeight != null) {
                double weight = fishWeight.floatValue();
                String lb = weight == 1.0 ? " lb" : " lbs";
                DecimalFormat df = new DecimalFormat("#,###.##");
                BigDecimal bd = new BigDecimal(weight);
                if ((bd = bd.round(new MathContext(3))).doubleValue() > 999.0) {
                    MutableComponent doubleWeight = Component.translatable((String)"aquaculture.fishWeight.weight", (Object[])new Object[]{df.format((int)bd.doubleValue()) + lb});
                    event.getToolTip().add(doubleWeight.withStyle(doubleWeight.getStyle().withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY)));
                } else {
                    MutableComponent decimalWeight = Component.translatable((String)"aquaculture.fishWeight.weight", (Object[])new Object[]{String.valueOf(bd) + lb});
                    event.getToolTip().add(decimalWeight.withStyle(decimalWeight.getStyle().withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY)));
                }
            }
        }
    }

    private static void assignRandomWeight(ItemStack fish, double min, double max) {
        if (fish.isEmpty()) {
            return;
        }
        float weight = (float)(min + Math.random() * (max - min));
        if (!fish.has(AquaDataComponents.FISH_WEIGHT)) {
            fish.set(AquaDataComponents.FISH_WEIGHT, (Object)Float.valueOf(weight));
            if ((double)weight <= max * (double)0.1f) {
                fish.set(AquaDataComponents.FISH_SIZE, (Object)"juvenile");
            } else if ((double)weight > max * (double)0.1f && (double)weight <= max * (double)0.2f) {
                fish.set(AquaDataComponents.FISH_SIZE, (Object)"small");
            } else if ((double)weight >= max * (double)0.8f && (double)weight < max * (double)0.9f) {
                fish.set(AquaDataComponents.FISH_SIZE, (Object)"large");
            } else if ((double)weight >= max * (double)0.9f) {
                fish.set(AquaDataComponents.FISH_SIZE, (Object)"massive");
            }
        }
    }

    public static void registerFishData() {
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.ATLANTIC_COD.get(), 10.0, 211.0, 6);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.BLACKFISH.get(), 1.0, 28.0, 2);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.PACIFIC_HALIBUT.get(), 25.0, 550.0, 12);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.ATLANTIC_HALIBUT.get(), 50.0, 710.0, 14);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.ATLANTIC_HERRING.get(), 0.5, 2.4, 1);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.PINK_SALMON.get(), 1.5, 15.0, 2);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.POLLOCK.get(), 3.0, 46.0, 2);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.RAINBOW_TROUT.get(), 2.0, 27.0, 2);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.BAYAD.get(), 5.0, 145.0, 4);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.BOULTI.get(), 1.0, 9.5, 1);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.CAPITAINE.get(), 20.0, 440.0, 10);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.SYNODONTIS.get(), 0.5, 2.5, 1);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.SMALLMOUTH_BASS.get(), 1.0, 12.0, 2);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.BLUEGILL.get(), 0.8, 4.5, 1);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.BROWN_TROUT.get(), 1.5, 44.0, 2);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.CARP.get(), 2.0, 40.0, 2);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.CATFISH.get(), 10.0, 220.0, 6);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.GAR.get(), 8.0, 100.0, 4);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.MINNOW.get(), 0.2, 1.5, 0);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.MUSKELLUNGE.get(), 5.0, 70.0, 3);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.PERCH.get(), 0.5, 6.0, 1);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.ARAPAIMA.get(), 20.0, 440.0, 10);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.PIRANHA.get(), 0.5, 7.7, 1);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.TAMBAQUI.get(), 7.0, 97.0, 3);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.BROWN_SHROOMA.get(), 1.0, 5.0, 0);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.RED_SHROOMA.get(), 1.0, 5.0, 0);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.JELLYFISH.get(), 5.0, 400.0, 0);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.RED_GROUPER.get(), 4.0, 50.0, 3);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.TUNA.get(), 30.0, 1508.0, 10);
        AquacultureAPI.FISH_DATA.add((Item)AquaItems.GOLDFISH.get(), 0.05, 5.0, 0);
        AquacultureAPI.FISH_DATA.add(Items.COD, 12.0, 211.0, 4);
        AquacultureAPI.FISH_DATA.add(Items.SALMON, 0.6, 15.0, 2);
        AquacultureAPI.FISH_DATA.add(Items.TROPICAL_FISH, 0.01, 1.0, 0);
        AquacultureAPI.FISH_DATA.add(Items.PUFFERFISH, 1.0, 25.0, 1);
    }
}

