/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.misc;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import com.teammetallurgy.aquaculture.init.AquaDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="aquaculture", value={Dist.CLIENT})
public class AquaTooltip {
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.isEmpty()) {
            Identifier id;
            Item item = stack.getItem();
            if (stack.is(AquacultureAPI.Tags.TOOLTIP) && (id = BuiltInRegistries.ITEM.getKey((Object)item)) != null) {
                String itemIdentifier = id.getPath() + ".tooltip";
                if (InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)340)) {
                    event.getToolTip().add(Component.translatable((String)("aquaculture." + itemIdentifier + ".desc")).withStyle(ChatFormatting.AQUA));
                } else {
                    event.getToolTip().add(Component.translatable((String)("aquaculture." + itemIdentifier + ".title")).withStyle(ChatFormatting.AQUA).append(" ").append((Component)Component.translatable((String)"aquaculture.shift").withStyle(ChatFormatting.DARK_GRAY)));
                }
            }
            if (stack.is(AquaBlocks.NEPTUNES_BOUNTY.asItem()) && stack.has(AquaDataComponents.ROD_INVENTORY)) {
                event.getToolTip().clear();
                event.getToolTip().add(stack.getStyledHoverName());
                event.getToolTip().add(Component.literal((String)"???????").withStyle(ChatFormatting.ITALIC));
            }
        }
    }
}

