/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.block;

import com.mojang.serialization.MapCodec;
import com.teammetallurgy.aquaculture.block.blockentity.TackleBoxBlockEntity;
import com.teammetallurgy.aquaculture.init.AquaBlockEntities;
import com.teammetallurgy.aquaculture.misc.StackHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class TackleBoxBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<TackleBoxBlock> CODEC = TackleBoxBlock.simpleCodec(TackleBoxBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape NORTH_SOUTH = Block.box((double)0.8, (double)0.0, (double)3.9, (double)15.2, (double)9.0, (double)12.2);
    private static final VoxelShape EAST_WEST = Block.box((double)3.9, (double)0.0, (double)0.8, (double)12.2, (double)9.0, (double)15.2);

    public TackleBoxBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.METAL).strength(4.0f, 5.0f).sound(SoundType.METAL));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TackleBoxBlockEntity(pos, state);
    }

    @Nonnull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter blockReader, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        switch ((Direction)state.getValue(FACING)) {
            case NORTH: 
            case SOUTH: {
                return NORTH_SOUTH;
            }
            case EAST: 
            case WEST: {
                return EAST_WEST;
            }
        }
        return super.getShape(state, blockReader, pos, context);
    }

    @Nonnull
    public InteractionResult useWithoutItem(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider container = this.getMenuProvider(state, level, pos);
        if (container != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.isShiftKeyDown()) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity != null) {
                    ItemStack giveStack = new ItemStack((ItemLike)this);
                    StackHelper.saveToItem(giveStack, (HolderLookup.Provider)player.level().registryAccess(), blockEntity);
                    StackHelper.giveItem((Player)serverPlayer, giveStack);
                    level.removeBlock(pos, false);
                    level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.6f, 0.8f);
                }
            } else {
                serverPlayer.openMenu(container, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction placerFacing = context.getHorizontalDirection().getOpposite();
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)placerFacing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public void setPlacedBy(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.has(DataComponents.CUSTOM_NAME) && (blockEntity = world.getBlockEntity(pos)) instanceof TackleBoxBlockEntity) {
            ((TackleBoxBlockEntity)blockEntity).setCustomName(stack.getHoverName());
        }
    }

    @Nonnull
    public BlockState updateShape(BlockState state, @Nonnull LevelReader level, @Nonnull ScheduledTickAccess scheduledTickAccess, @Nonnull BlockPos pos, @Nonnull Direction direction, @Nonnull BlockPos neighborPos, @Nonnull BlockState neighborState, @Nonnull RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean hasAnalogOutputSignal(@Nonnull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos) {
        IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
        if (handler != null) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)handler);
        }
        return 0;
    }

    @Nonnull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    @Nonnull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    protected boolean isPathfindable(@Nonnull BlockState state, @Nonnull PathComputationType pathComputationType) {
        return false;
    }

    protected void affectNeighborsAfterRemoval(@Nonnull BlockState state, @Nonnull ServerLevel serverLevel, @Nonnull BlockPos pos, boolean isMoving) {
        serverLevel.updateNeighbourForOutputSignal(pos, (Block)this);
    }

    public void playerDestroy(@Nonnull Level level, Player player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable BlockEntity blockEntity, @Nonnull ItemStack stack) {
        player.awardStat(Stats.BLOCK_MINED.get((Object)this));
        player.causeFoodExhaustion(0.005f);
    }

    public boolean onDestroyedByPlayer(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, boolean willHarvest, @Nonnull FluidState fluid) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TackleBoxBlockEntity) {
            ItemStack tackleBox = new ItemStack((ItemLike)this);
            StackHelper.saveToItem(tackleBox, (HolderLookup.Provider)player.level().registryAccess(), blockEntity);
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)tackleBox);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Nonnull
    public ItemStack getCloneItemStack(@Nonnull LevelReader level, @Nonnull BlockPos pos, @Nonnull BlockState state, boolean includeData, @Nonnull Player player) {
        ItemStack cloneItemStack = super.getCloneItemStack(level, pos, state, includeData, player);
        level.getBlockEntity(pos, (BlockEntityType)AquaBlockEntities.TACKLE_BOX.get()).ifPresent(blockEntity -> StackHelper.saveToItem(cloneItemStack, (HolderLookup.Provider)player.level().registryAccess(), blockEntity));
        return cloneItemStack;
    }

    public void onBlockExploded(@Nonnull BlockState state, ServerLevel level, @Nonnull BlockPos pos, @Nonnull Explosion explosion) {
        IItemHandler handler;
        if (!level.isClientSide && (handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
            StackHelper.dropInventory((Level)level, pos, handler);
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? TackleBoxBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)AquaBlockEntities.TACKLE_BOX.get()), TackleBoxBlockEntity::lidAnimateTick) : null;
    }

    public void tick(@Nonnull BlockState state, ServerLevel serverLevel, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        BlockEntity blockEntity = serverLevel.getBlockEntity(pos);
        if (blockEntity instanceof TackleBoxBlockEntity) {
            ((TackleBoxBlockEntity)blockEntity).recheckOpen();
        }
    }
}

