/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teammetallurgy.aquaculture.block.TackleBoxBlock;
import com.teammetallurgy.aquaculture.block.blockentity.TackleBoxBlockEntity;
import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.client.model.TackleBoxModel;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class TackleBoxRenderer<T extends TackleBoxBlockEntity>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation TACKLE_BOX_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/block/tackle_box.png");
    public final TackleBoxModel tackleBoxModel;

    public TackleBoxRenderer(BlockEntityRendererProvider.Context context) {
        this.tackleBoxModel = new TackleBoxModel(context.bakeLayer(ClientHandler.TACKLE_BOX));
    }

    public void render(@Nonnull T tackleBox, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 cameraPosition) {
        Level world = tackleBox.getLevel();
        boolean hasWorld = world != null;
        BlockState state = hasWorld ? tackleBox.getBlockState() : (BlockState)((Block)AquaBlocks.TACKLE_BOX.get()).defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        Block block = state.getBlock();
        if (block instanceof TackleBoxBlock) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.5, 0.5);
            float facing = ((Direction)state.getValue(TackleBoxBlock.FACING)).toYRot();
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-facing));
            matrixStack.translate(-0.5, -0.5, -0.5);
            matrixStack.translate(0.0625f, 1.125f, 0.5f);
            matrixStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(-180.0f));
            DoubleBlockCombiner.NeighborCombineResult callbackWrapper = DoubleBlockCombiner.Combiner::acceptNone;
            float angle = ((TackleBoxBlockEntity)((Object)tackleBox)).getOpenNess(partialTicks);
            angle = 1.0f - angle;
            angle = 1.0f - angle * angle * angle;
            int brightness = ((Int2IntFunction)callbackWrapper.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(combinedLight);
            VertexConsumer tackleBoxBuilder = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)TACKLE_BOX_TEXTURE));
            this.render(matrixStack, tackleBoxBuilder, this.tackleBoxModel, angle, brightness, combinedOverlay);
            matrixStack.popPose();
        }
    }

    private void render(PoseStack poseStack, VertexConsumer buffer, TackleBoxModel tackleBoxModel, float angle, int packedLight, int packedOverlay) {
        tackleBoxModel.setupAnim(angle);
        tackleBoxModel.renderToBuffer(poseStack, buffer, packedLight, packedOverlay);
    }
}

