/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teammetallurgy.aquaculture.client.renderer.entity.state.AquaBobberRenderState;
import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.FishingHookRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class AquaBobberRenderer
extends EntityRenderer<AquaFishingBobberEntity, AquaBobberRenderState> {
    private static final ResourceLocation BOBBER = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/bobber/bobber.png");
    private static final ResourceLocation BOBBER_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/bobber/bobber_overlay.png");
    private static final ResourceLocation BOBBER_VANILLA = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/bobber/bobber_vanilla.png");
    private static final ResourceLocation HOOK = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/rod/hook/hook.png");
    private static final RenderType BOBBER_RENDER = RenderType.entityCutout((ResourceLocation)BOBBER);
    private static final RenderType BOBBER_OVERLAY_RENDER = RenderType.entityCutout((ResourceLocation)BOBBER_OVERLAY);
    private static final RenderType BOBBER_VANILLA_RENDER = RenderType.entityCutout((ResourceLocation)BOBBER_VANILLA);
    private static final RenderType HOOK_RENDER = RenderType.entityCutout((ResourceLocation)HOOK);

    public AquaBobberRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRender(@Nonnull AquaFishingBobberEntity bobber, @Nonnull Frustum frustum, double x, double y, double z) {
        return super.shouldRender((Entity)bobber, frustum, x, y, z) && bobber.getPlayerOwner() != null;
    }

    public void render(@Nonnull AquaBobberRenderState bobber, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight) {
        DyedItemColor dyeditemcolor;
        poseStack.pushPose();
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer bobberOverlayVertex = bobber.hasBobber ? buffer.getBuffer(BOBBER_OVERLAY_RENDER) : buffer.getBuffer(BOBBER_VANILLA_RENDER);
        ItemStack bobberStack = bobber.bobber;
        float bobberR = 1.0f;
        float bobberG = 1.0f;
        float bobberB = 1.0f;
        int bobberColorInt = ARGB.color((int)193, (int)38, (int)38);
        if (!bobberStack.isEmpty() && bobberStack.is(ItemTags.DYEABLE)) {
            DyedItemColor dyeditemcolor2 = (DyedItemColor)bobberStack.get(DataComponents.DYED_COLOR);
            if (dyeditemcolor2 != null) {
                bobberColorInt = dyeditemcolor2.rgb();
            }
            bobberR = (float)(bobberColorInt >> 16 & 0xFF) / 255.0f;
            bobberG = (float)(bobberColorInt >> 8 & 0xFF) / 255.0f;
            bobberB = (float)(bobberColorInt & 0xFF) / 255.0f;
        }
        AquaBobberRenderer.vertex(bobberOverlayVertex, pose, packedLight, 0.0f, 0, 0, 1, bobberR, bobberG, bobberB);
        AquaBobberRenderer.vertex(bobberOverlayVertex, pose, packedLight, 1.0f, 0, 1, 1, bobberR, bobberG, bobberB);
        AquaBobberRenderer.vertex(bobberOverlayVertex, pose, packedLight, 1.0f, 1, 1, 0, bobberR, bobberG, bobberB);
        AquaBobberRenderer.vertex(bobberOverlayVertex, pose, packedLight, 0.0f, 1, 0, 0, bobberR, bobberG, bobberB);
        if (bobber.hasBobber) {
            VertexConsumer bobberVertex = buffer.getBuffer(BOBBER_RENDER);
            AquaBobberRenderer.renderPosTexture(bobberVertex, pose, packedLight, 0.0f, 0, 0, 1);
            AquaBobberRenderer.renderPosTexture(bobberVertex, pose, packedLight, 1.0f, 0, 1, 1);
            AquaBobberRenderer.renderPosTexture(bobberVertex, pose, packedLight, 1.0f, 1, 1, 0);
            AquaBobberRenderer.renderPosTexture(bobberVertex, pose, packedLight, 0.0f, 1, 0, 0);
        }
        VertexConsumer hookVertex = bobber.hasHook ? buffer.getBuffer(RenderType.entityCutout((ResourceLocation)bobber.hook.getTexture())) : buffer.getBuffer(HOOK_RENDER);
        AquaBobberRenderer.renderPosTexture(hookVertex, pose, packedLight, 0.0f, 0, 0, 1);
        AquaBobberRenderer.renderPosTexture(hookVertex, pose, packedLight, 1.0f, 0, 1, 1);
        AquaBobberRenderer.renderPosTexture(hookVertex, pose, packedLight, 1.0f, 1, 1, 0);
        AquaBobberRenderer.renderPosTexture(hookVertex, pose, packedLight, 0.0f, 1, 0, 0);
        poseStack.popPose();
        float x = (float)bobber.lineOriginOffset.x;
        float y = (float)bobber.lineOriginOffset.y;
        float z = (float)bobber.lineOriginOffset.z;
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.lineStrip());
        PoseStack.Pose linePose = poseStack.last();
        ItemStack line = bobber.fishingLine;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (!line.isEmpty() && line.is(ItemTags.DYEABLE) && (dyeditemcolor = (DyedItemColor)line.get(DataComponents.DYED_COLOR)) != null) {
            int colorInt = dyeditemcolor.rgb();
            r = (float)(colorInt >> 16 & 0xFF) / 255.0f;
            g = (float)(colorInt >> 8 & 0xFF) / 255.0f;
            b = (float)(colorInt & 0xFF) / 255.0f;
        }
        for (int size = 0; size < 16; ++size) {
            AquaBobberRenderer.stringVertex(x, y, z, vertexConsumer, linePose, (float)size / 14.9f, (float)(size + 1) / 14.9f, r, g, b);
        }
        poseStack.popPose();
        super.render((EntityRenderState)bobber, poseStack, buffer, packedLight);
    }

    private static void renderPosTexture(VertexConsumer builder, PoseStack.Pose pose, int packedLight, float x, int y, int u, int v) {
        builder.addVertex(pose, x - 0.5f, (float)y - 0.5f, 0.0f).setColor(255, 255, 255, 255).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
    }

    private static void vertex(VertexConsumer builder, PoseStack.Pose pose, int packedLight, float x, int y, int u, int v, float r, float g, float b) {
        builder.addVertex(pose, x - 0.5f, (float)y - 0.5f, 0.0f).setColor(r, g, b, 1.0f).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
    }

    private static void stringVertex(float x, float y, float z, VertexConsumer vertexConsumer, PoseStack.Pose pose, float f1, float f2, float r, float g, float b) {
        float var7 = x * f1;
        float var8 = y * (f1 * f1 + f1) * 0.5f + 0.25f;
        float var9 = z * f1;
        float var10 = x * f2 - var7;
        float var11 = y * (f2 * f2 + f2) * 0.5f + 0.25f - var8;
        float var12 = z * f2 - var9;
        float var13 = Mth.sqrt((float)(var10 * var10 + var11 * var11 + var12 * var12));
        vertexConsumer.addVertex(pose.pose(), var7, var8, var9).setColor(r, g, b, 1.0f).setNormal(pose, var10 /= var13, var11 /= var13, var12 /= var13);
    }

    private static float fraction(int numerator, int denominator) {
        return (float)numerator / (float)denominator;
    }

    private Vec3 getPlayerHandPos(Player player, float handAngle, float partialTick) {
        int i;
        int n = i = FishingHookRenderer.getHoldingArm((Player)player) == HumanoidArm.RIGHT ? 1 : -1;
        if (this.entityRenderDispatcher.options.getCameraType().isFirstPerson() && player == Minecraft.getInstance().player) {
            double d4 = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
            Vec3 vec3 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)i * 0.525f, -0.1f).scale(d4).yRot(handAngle * 0.5f).xRot(-handAngle * 0.7f);
            return player.getEyePosition(partialTick).add(vec3);
        }
        float f = Mth.lerp((float)partialTick, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
        double d0 = Mth.sin((float)f);
        double d1 = Mth.cos((float)f);
        float f1 = player.getScale();
        double d2 = (double)i * 0.35 * (double)f1;
        double d3 = 0.8 * (double)f1;
        float f2 = player.isCrouching() ? -0.1875f : 0.0f;
        return player.getEyePosition(partialTick).add(-d1 * d2 - d0 * d3, (double)f2 - 0.45 * (double)f1, -d0 * d2 + d1 * d3);
    }

    @Nonnull
    public AquaBobberRenderState createRenderState() {
        return new AquaBobberRenderState();
    }

    public void extractRenderState(@Nonnull AquaFishingBobberEntity bobber, @Nonnull AquaBobberRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)bobber, (EntityRenderState)reusedState, partialTick);
        Player player = bobber.getPlayerOwner();
        if (player == null) {
            reusedState.lineOriginOffset = Vec3.ZERO;
        } else {
            float attackAnim = player.getAttackAnim(partialTick);
            float f1 = Mth.sin((float)(Mth.sqrt((float)attackAnim) * (float)Math.PI));
            Vec3 vec3 = this.getPlayerHandPos(player, f1, partialTick);
            Vec3 vec31 = bobber.getPosition(partialTick).add(0.0, 0.25, 0.0);
            reusedState.lineOriginOffset = vec3.subtract(vec31);
        }
        reusedState.hasBobber = bobber.hasBobber();
        reusedState.hasHook = bobber.hasHook();
        reusedState.bobber = bobber.getBobber();
        reusedState.fishingLine = bobber.getFishingLine();
        reusedState.hook = bobber.getHook();
    }

    protected boolean affectedByCulling(@Nonnull AquaFishingBobberEntity bobber) {
        return false;
    }
}

