/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.client.renderer.entity.state.FishMountRenderState;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishMountEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import com.teammetallurgy.aquaculture.init.AquaDataComponents;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import org.joml.Quaternionfc;

public class FishMountRenderer<T extends FishMountEntity>
extends EntityRenderer<T, FishMountRenderState> {
    private final Minecraft mc = Minecraft.getInstance();
    private final ItemModelResolver itemModelResolver;

    public FishMountRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemModelResolver = context.getItemModelResolver();
    }

    public void render(@Nonnull FishMountRenderState renderState, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int i) {
        float y;
        float x;
        super.render((EntityRenderState)renderState, poseStack, buffer, i);
        poseStack.pushPose();
        Direction direction = renderState.direction;
        Vec3 pos = this.getRenderOffset(renderState);
        poseStack.translate(-pos.x(), -pos.y(), -pos.z());
        double multiplier = 0.46875;
        poseStack.translate((double)direction.getStepX() * multiplier, (double)direction.getStepY() * multiplier, (double)direction.getStepZ() * multiplier);
        if (direction.getAxis().isHorizontal()) {
            x = 0.0f;
            y = 180.0f - direction.toYRot();
        } else {
            x = -90 * direction.getAxisDirection().getStep();
            y = 180.0f;
        }
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(x));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(y));
        if (!renderState.isInvisible) {
            BlockStateModel model;
            BlockRenderDispatcher rendererDispatcher = this.mc.getBlockRenderer();
            ModelManager manager = rendererDispatcher.getBlockModelShaper().getModelManager();
            poseStack.pushPose();
            poseStack.translate(-0.5, -0.5, -0.5);
            ResourceLocation entityTypeID = renderState.byName;
            if (entityTypeID != null && (model = (BlockStateModel)manager.getStandaloneModel(this.getStandaloneKeyFromType(entityTypeID.getPath()))) != null) {
                ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (VertexConsumer)buffer.getBuffer(RenderType.entitySolidZOffsetForward((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)), (BlockStateModel)model, (float)1.0f, (float)1.0f, (float)1.0f, (int)i, (int)OverlayTexture.NO_OVERLAY);
            }
            poseStack.popPose();
        }
        this.renderFish(renderState, poseStack, buffer, i);
        poseStack.popPose();
    }

    private void renderFish(FishMountRenderState renderState, PoseStack poseStack, MultiBufferSource buffer, int i) {
        Entity entity = renderState.mountedFish;
        if (entity instanceof Mob) {
            Mob fish = (Mob)entity;
            double x = 0.0;
            double y = 0.0;
            double depth = 0.42;
            if (fish instanceof Pufferfish) {
                depth += 0.09;
            } else if (fish instanceof AquaFishEntity && ((AquaFishEntity)fish).getFishType().equals((Object)FishType.LONGNOSE)) {
                x = -0.1f;
                y = -0.18;
            }
            fish.setNoAi(true);
            poseStack.translate(x, y, depth);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
            this.mc.getEntityRenderDispatcher().render((Entity)fish, 0.0, 0.0, 0.0, 0.0f, poseStack, buffer, i);
        }
    }

    @Nonnull
    public Vec3 getRenderOffset(FishMountRenderState fishMount) {
        return new Vec3((double)((float)fishMount.direction.getStepX() * 0.3f), -0.25, (double)((float)fishMount.direction.getStepZ() * 0.3f));
    }

    protected boolean shouldShowName(@Nonnull T fishMount, double distanceToCameraSq) {
        if (Minecraft.renderNames() && ((FishMountEntity)((Object)fishMount)).entity != null && this.mc.hitResult != null && fishMount.distanceToSqr(this.mc.hitResult.getLocation()) < 0.24) {
            double d0 = this.entityRenderDispatcher.distanceToSqr(fishMount);
            float sneaking = fishMount.isDiscrete() ? 32.0f : 64.0f;
            return d0 < (double)(sneaking * sneaking);
        }
        return false;
    }

    protected void renderNameTag(@Nonnull FishMountRenderState renderState, @Nonnull Component name, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int i) {
        super.renderNameTag((EntityRenderState)renderState, renderState.mountedFish.getName(), matrixStack, buffer, i);
        ItemStack stack = renderState.stack;
        Float fishWeight = (Float)stack.get((DataComponentType)AquaDataComponents.FISH_WEIGHT.get());
        if (stack.has(AquaDataComponents.FISH_WEIGHT) && fishWeight != null) {
            float weight = fishWeight.floatValue();
            String lb = (double)weight == 1.0 ? " lb" : " lbs";
            DecimalFormat df = new DecimalFormat("#,###.##");
            BigDecimal bd = new BigDecimal(weight);
            bd = bd.round(new MathContext(3));
            matrixStack.pushPose();
            matrixStack.translate(0.0, -0.25, 0.0);
            if (bd.doubleValue() > 999.0) {
                super.renderNameTag((EntityRenderState)renderState, (Component)Component.translatable((String)"aquaculture.fishWeight.weight", (Object[])new Object[]{df.format((int)bd.doubleValue()) + lb}), matrixStack, buffer, i - 100);
            } else {
                super.renderNameTag((EntityRenderState)renderState, (Component)Component.translatable((String)"aquaculture.fishWeight.weight", (Object[])new Object[]{String.valueOf(bd) + lb}), matrixStack, buffer, i);
            }
            matrixStack.popPose();
        }
    }

    @Nonnull
    public FishMountRenderState createRenderState() {
        return new FishMountRenderState();
    }

    public void extractRenderState(@Nonnull T entity, @Nonnull FishMountRenderState renderState, float partialTicks) {
        ItemStack itemstack;
        super.extractRenderState(entity, (EntityRenderState)renderState, partialTicks);
        renderState.direction = entity.getDirection();
        renderState.stack = itemstack = ((FishMountEntity)((Object)entity)).getItem();
        this.itemModelResolver.updateForNonLiving(renderState.item, itemstack, ItemDisplayContext.FIXED, entity);
        renderState.byName = ((FishMountEntity)((Object)entity)).byName();
        renderState.mountedFish = ((FishMountEntity)((Object)entity)).entity;
    }

    public StandaloneModelKey<BlockStateModel> getStandaloneKeyFromType(String mountType) {
        return switch (mountType) {
            case "spruce_fish_mount" -> ClientHandler.SPRUCE_FISH_MOUNT_KEY;
            case "birch_fish_mount" -> ClientHandler.BIRCH_FISH_MOUNT_KEY;
            case "jungle_fish_mount" -> ClientHandler.JUNGLE_FISH_MOUNT_KEY;
            case "acacia_fish_mount" -> ClientHandler.ACACIA_FISH_MOUNT_KEY;
            case "dark_oak_fish_mount" -> ClientHandler.DARK_OAK_FISH_MOUNT_KEY;
            default -> ClientHandler.OAK_FISH_MOUNT_KEY;
        };
    }
}

