/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.client.model.NeptunesBountyModel;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class NeptunesBountySpecialRenderer
implements NoDataSpecialModelRenderer {
    public static final ResourceLocation NEPTUNES_BOUNTY = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"neptunes");
    private final NeptunesBountyModel model;
    private final Material material;
    private final float openness;

    public NeptunesBountySpecialRenderer(NeptunesBountyModel model, Material material, float openness) {
        this.model = model;
        this.material = material;
        this.openness = openness;
    }

    public void render(@Nonnull ItemDisplayContext displayContext, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean b) {
        VertexConsumer vertexconsumer = this.material.buffer(bufferSource, RenderType::entitySolid);
        this.model.setupAnim(this.openness);
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, packedOverlay);
    }

    public void getExtents(Set<Vector3f> output) {
        PoseStack posestack = new PoseStack();
        this.model.setupAnim(this.openness);
        this.model.root().getExtentsForGui(posestack, output);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(ResourceLocation texture, float openness) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(m -> m.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Unbaked::texture), (App)Codec.FLOAT.optionalFieldOf("openness", (Object)Float.valueOf(0.0f)).forGetter(Unbaked::openness)).apply((Applicative)m, Unbaked::new));

        public Unbaked(ResourceLocation location) {
            this(location, 0.0f);
        }

        @Nonnull
        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            NeptunesBountyModel neptunesBountyModel = new NeptunesBountyModel(modelSet.bakeLayer(ClientHandler.NEPTUNES_BOUNTY));
            Material material = Sheets.CHEST_MAPPER.apply(this.texture);
            return new NeptunesBountySpecialRenderer(neptunesBountyModel, material, this.openness);
        }
    }
}

