/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.teammetallurgy.aquaculture.block.FarmlandMoistBlock;
import com.teammetallurgy.aquaculture.block.NeptunesBountyBlock;
import com.teammetallurgy.aquaculture.block.TackleBoxBlock;
import com.teammetallurgy.aquaculture.block.WormFarmBlock;
import com.teammetallurgy.aquaculture.init.AquaBlockEntities;
import com.teammetallurgy.aquaculture.init.AquaItems;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AquaBlocks {
    public static final DeferredRegister.Blocks BLOCK_DEFERRED = DeferredRegister.createBlocks((String)"aquaculture");
    public static final DeferredBlock<Block> FARMLAND = AquaBlocks.register(FarmlandMoistBlock::new, "farmland", false);
    public static final DeferredBlock<Block> NEPTUNIUM_BLOCK = AquaBlocks.register(p -> new Block(p.mapColor(MapColor.COLOR_CYAN).strength(5.0f, 6.0f).sound(SoundType.METAL)), "neptunium_block");
    public static final DeferredBlock<Block> NEPTUNES_BOUNTY = AquaBlocks.register(p -> new NeptunesBountyBlock(() -> AquaBlockEntities.NEPTUNES_BOUNTY.get(), (BlockBehaviour.Properties)p), "neptunes_bounty");
    public static final DeferredBlock<Block> TACKLE_BOX = AquaBlocks.register(TackleBoxBlock::new, "tackle_box");
    public static final DeferredBlock<Block> WORM_FARM = AquaBlocks.register(WormFarmBlock::new, "worm_farm");

    public static DeferredBlock<Block> register(Function<BlockBehaviour.Properties, ? extends Block> function, @Nonnull String name) {
        return AquaBlocks.register(function, name, true);
    }

    public static DeferredBlock<Block> register(Function<BlockBehaviour.Properties, ? extends Block> function, @Nonnull String name, boolean addToItemGroup) {
        DeferredBlock block = BLOCK_DEFERRED.registerBlock(name, function);
        if (addToItemGroup) {
            AquaItems.registerWithTab(p -> new BlockItem((Block)block.get(), p.useBlockDescriptionPrefix()), name);
        } else {
            AquaItems.register((Item.Properties p) -> new BlockItem((Block)block.get(), p.useBlockDescriptionPrefix()), name);
        }
        return block;
    }
}

