/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import com.teammetallurgy.aquaculture.entity.SpectralWaterArrowEntity;
import com.teammetallurgy.aquaculture.entity.TurtleLandEntity;
import com.teammetallurgy.aquaculture.entity.WaterArrowEntity;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.FishRegistry;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="aquaculture")
public class AquaEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_DEFERRED = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"aquaculture");
    public static final DeferredHolder<EntityType<?>, EntityType<AquaFishingBobberEntity>> BOBBER = AquaEntities.register("bobber", () -> EntityType.Builder.of(AquaFishingBobberEntity::new, (MobCategory)MobCategory.MISC).noSave().noSummon().sized(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(5));
    public static final DeferredHolder<EntityType<?>, EntityType<WaterArrowEntity>> WATER_ARROW = AquaEntities.register("water_arrow", () -> EntityType.Builder.of(WaterArrowEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).eyeHeight(0.13f).clientTrackingRange(4).updateInterval(20));
    public static final DeferredHolder<EntityType<?>, EntityType<SpectralWaterArrowEntity>> SPECTRAL_WATER_ARROW = AquaEntities.register("spectral_water_arrow", () -> EntityType.Builder.of(SpectralWaterArrowEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).eyeHeight(0.13f).clientTrackingRange(4).updateInterval(20));
    public static final DeferredHolder<EntityType<?>, EntityType<TurtleLandEntity>> BOX_TURTLE = AquaEntities.registerMob("box_turtle", () -> EntityType.Builder.of(TurtleLandEntity::new, (MobCategory)MobCategory.CREATURE).eyeHeight(0.1875f).sized(0.5f, 0.25f));
    public static final DeferredHolder<EntityType<?>, EntityType<TurtleLandEntity>> ARRAU_TURTLE = AquaEntities.registerMob("arrau_turtle", () -> EntityType.Builder.of(TurtleLandEntity::new, (MobCategory)MobCategory.CREATURE).eyeHeight(0.1875f).sized(0.5f, 0.25f));
    public static final DeferredHolder<EntityType<?>, EntityType<TurtleLandEntity>> STARSHELL_TURTLE = AquaEntities.registerMob("starshell_turtle", () -> EntityType.Builder.of(TurtleLandEntity::new, (MobCategory)MobCategory.CREATURE).eyeHeight(0.1875f).sized(0.5f, 0.25f));

    private static <T extends Mob> DeferredHolder<EntityType<?>, EntityType<T>> registerMob(String name, Supplier<EntityType.Builder<T>> builder) {
        DeferredHolder entityType = AquaEntities.register(name, builder);
        DeferredItem<Item> spawnEggItem = AquaItems.registerWithTab(p -> new SpawnEggItem((EntityType)entityType.get(), p), name + "_spawn_egg");
        AquaItems.SPAWN_EGGS.add(spawnEggItem);
        return entityType;
    }

    public static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String name, Supplier<EntityType.Builder<T>> builder) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)name);
        return ENTITY_DEFERRED.register(name, () -> ((EntityType.Builder)builder.get()).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)location)));
    }

    @SubscribeEvent
    public static void setSpawnPlacement(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)BOX_TURTLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)ARRAU_TURTLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)STARSHELL_TURTLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        for (DeferredHolder<EntityType<?>, EntityType<AquaFishEntity>> entityType : FishRegistry.fishEntities) {
            event.register((EntityType)entityType.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::checkSurfaceWaterAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        }
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)BOX_TURTLE.get(), TurtleLandEntity.createAttributes().build());
        event.put((EntityType)ARRAU_TURTLE.get(), TurtleLandEntity.createAttributes().build());
        event.put((EntityType)STARSHELL_TURTLE.get(), TurtleLandEntity.createAttributes().build());
        for (DeferredHolder<EntityType<?>, EntityType<AquaFishEntity>> entityType : FishRegistry.fishEntities) {
            event.put((EntityType)entityType.get(), AquaFishEntity.createAttributes().build());
        }
    }
}

