/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishMountEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.item.AquaFishBucket;
import com.teammetallurgy.aquaculture.item.FishMountItem;
import com.teammetallurgy.aquaculture.loot.BiomeTagCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(modid="aquaculture")
public class FishRegistry {
    public static List<DeferredHolder<EntityType<?>, EntityType<AquaFishEntity>>> fishEntities = new ArrayList();
    public static List<DeferredHolder<EntityType<?>, EntityType<FishMountEntity>>> fishMounts = new ArrayList();

    public static DeferredItem<Item> registerFishMount(@Nonnull String name) {
        DeferredHolder fishMount = AquaEntities.ENTITY_DEFERRED.register(name, () -> EntityType.Builder.of(FishMountEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).eyeHeight(0.0f).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)name))));
        DeferredItem<Item> fishMountItem = AquaItems.registerWithTab(p -> new FishMountItem((Supplier<EntityType<FishMountEntity>>)fishMount, (Item.Properties)p), name);
        fishMounts.add(fishMount);
        return fishMountItem;
    }

    public static DeferredItem<Item> register(Function<Item.Properties, ? extends Item> function, @Nonnull String name) {
        return FishRegistry.register(function, name, FishType.MEDIUM);
    }

    public static DeferredItem<Item> register(Function<Item.Properties, ? extends Item> function, @Nonnull String name, FishType fishType) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)name);
        DeferredHolder fish = AquaEntities.ENTITY_DEFERRED.register(name, () -> EntityType.Builder.of((f, w) -> new AquaFishEntity((EntityType<? extends AbstractSchoolingFish>)f, w, fishType), (MobCategory)MobCategory.WATER_AMBIENT).sized(fishType.getWidth(), fishType.getHeight()).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)id)));
        fishEntities.add(fish);
        DeferredItem<Item> bucket = AquaItems.register(p -> new AquaFishBucket((EntityType<? extends Mob>)((EntityType)fish.value()), p.stacksTo(1)), name + "_bucket");
        AquaItems.ITEMS_FOR_TAB_LIST.add(bucket);
        return AquaItems.registerWithTab(function, name);
    }

    @SubscribeEvent
    public static void registerFishies(RegisterEvent event) {
        if (!event.getRegistryKey().equals(Registries.LOOT_CONDITION_TYPE)) {
            return;
        }
        event.register(Registries.LOOT_CONDITION_TYPE, ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"biome_tag_check"), () -> BiomeTagCheck.BIOME_TAG_CHECK);
    }
}

