/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item.neptunium;

import com.mojang.datafixers.util.Pair;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;

public class NeptuniumHoe
extends HoeItem {
    public NeptuniumHoe(ToolMaterial toolMaterial, int damage, float speed, Item.Properties properties) {
        super(toolMaterial, (float)damage, speed, properties);
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Pair pair;
        BlockPos pos;
        Level level = context.getLevel();
        BlockState toolModifiedState = level.getBlockState(pos = context.getClickedPos()).getToolModifiedState(context, ItemAbilities.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, (Object)NeptuniumHoe.changeIntoState((BlockState)toolModifiedState));
        if (pair == null) {
            return InteractionResult.PASS;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        if (predicate.test(context)) {
            Player player = context.getPlayer();
            level.playSound((Entity)player, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide) {
                level.setBlock(pos, ((Block)AquaBlocks.FARMLAND.get()).defaultBlockState(), 2);
                if (player != null) {
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

