/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.block;

import com.mojang.serialization.MapCodec;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.AquaSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;

public class WormFarmBlock
extends ComposterBlock {
    public static final MapCodec<ComposterBlock> CODEC = WormFarmBlock.simpleCodec(WormFarmBlock::new);

    public WormFarmBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(0.6f).sound(SoundType.WOOD));
    }

    @Nonnull
    public MapCodec<ComposterBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public InteractionResult useItemOn(@Nonnull ItemStack stack, BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult blockHitResult) {
        int stateLevel = (Integer)state.getValue((Property)LEVEL);
        ItemStack heldStack = player.getItemInHand(hand);
        if (heldStack.getItemHolder().getData(NeoForgeDataMaps.COMPOSTABLES) != null) {
            if (stateLevel < 8 && !level.isClientSide) {
                boolean addItem = WormFarmBlock.addItem(state, (LevelAccessor)level, pos, heldStack);
                level.levelEvent(1500, pos, addItem ? 1 : 0);
                if (!player.getAbilities().instabuild) {
                    heldStack.shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (stateLevel > 0) {
            if (!level.isClientSide) {
                double x = (double)(level.random.nextFloat() * 0.7f) + (double)0.15f;
                double y = (double)(level.random.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
                double z = (double)(level.random.nextFloat() * 0.7f) + (double)0.15f;
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + x, (double)pos.getY() + y, (double)pos.getZ() + z, new ItemStack((ItemLike)AquaItems.WORM.get()));
                itemEntity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itemEntity);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)LEVEL) - 1)), 3);
            level.playSound(null, pos, (SoundEvent)AquaSounds.WORM_FARM_EMPTY.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void tick(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
    }

    private static boolean addItem(BlockState state, LevelAccessor level, BlockPos pos, @Nonnull ItemStack stack) {
        int stateLevel = (Integer)state.getValue((Property)LEVEL);
        float chance = ComposterBlock.getValue((ItemStack)stack);
        if ((stateLevel != 0 || chance <= 0.0f) && level.getRandom().nextDouble() >= (double)chance) {
            return false;
        }
        int levelAdd = stateLevel + 1;
        level.setBlock(pos, (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(levelAdd)), 3);
        if (levelAdd == 7) {
            level.scheduleTick(pos, state.getBlock(), 20);
        }
        return true;
    }

    @Nonnull
    public WorldlyContainer getContainer(BlockState state, @Nonnull LevelAccessor levelAccessor, @Nonnull BlockPos pos) {
        int level = (Integer)state.getValue((Property)LEVEL);
        if (level == 8) {
            return new FullInventory(state, levelAccessor, pos, new ItemStack((ItemLike)AquaItems.WORM.get()));
        }
        return level < 7 ? new PartialInventory(state, levelAccessor, pos) : new EmptyInventory();
    }

    static class FullInventory
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor world;
        private final BlockPos pos;
        private boolean extracted;

        FullInventory(BlockState state, LevelAccessor world, BlockPos pos, @Nonnull ItemStack stack) {
            super(new ItemStack[]{stack});
            this.state = state;
            this.world = world;
            this.pos = pos;
        }

        public int getMaxStackSize() {
            return 1;
        }

        @Nonnull
        public int[] getSlotsForFace(@Nonnull Direction direction) {
            int[] nArray;
            if (direction == Direction.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean canPlaceItemThroughFace(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
            return false;
        }

        public boolean canTakeItemThroughFace(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
            return !this.extracted && direction == Direction.DOWN && stack.getItem() == AquaItems.WORM.get();
        }

        public void setChanged() {
            this.world.setBlock(this.pos, (BlockState)this.state.setValue((Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(0)), 3);
            this.extracted = true;
        }
    }

    static class PartialInventory
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor levelAccessor;
        private final BlockPos pos;
        private boolean inserted;

        PartialInventory(BlockState state, LevelAccessor levelAccessor, BlockPos pos) {
            super(1);
            this.state = state;
            this.levelAccessor = levelAccessor;
            this.pos = pos;
        }

        public int getMaxStackSize() {
            return 1;
        }

        @Nonnull
        public int[] getSlotsForFace(@Nonnull Direction direction) {
            int[] nArray;
            if (direction == Direction.UP) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean canPlaceItemThroughFace(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
            return !this.inserted && direction == Direction.UP && ComposterBlock.getValue((ItemStack)stack) > 0.0f;
        }

        public boolean canTakeItemThroughFace(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
            return false;
        }

        public void setChanged() {
            ItemStack stack = this.getItem(0);
            if (!stack.isEmpty()) {
                this.inserted = true;
                WormFarmBlock.addItem(this.state, this.levelAccessor, this.pos, stack);
                this.removeItemNoUpdate(0);
            }
        }
    }

    static class EmptyInventory
    extends SimpleContainer
    implements WorldlyContainer {
        EmptyInventory() {
            super(0);
        }

        @Nonnull
        public int[] getSlotsForFace(@Nonnull Direction direction) {
            return new int[0];
        }

        public boolean canPlaceItemThroughFace(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
            return false;
        }

        public boolean canTakeItemThroughFace(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
            return false;
        }
    }
}

