/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.AquaTropicalFishBModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishBaseModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishCathfishModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLargeModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLongnoseModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishMediumModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishSmallModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.JellyfishModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.state.AquaFishRenderState;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class AquaFishRenderer
extends MobRenderer<AquaFishEntity, AquaFishRenderState, FishBaseModel> {
    private static final ResourceLocation DEFAULT_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/fish/atlantic_cod.png");
    public static final ResourceLocation JELLYFISH = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/fish/jellyfish.png");
    private final AquaTropicalFishBModel tropicalFishBModel;
    private final FishSmallModel smallModel;
    private final FishMediumModel mediumModel;
    private final FishLargeModel largeModel;
    private final FishLongnoseModel longnoseModel;
    private final FishCathfishModel catfishModel;
    private final JellyfishModel jellyfishModel;

    public AquaFishRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new FishMediumModel(context.bakeLayer(ClientHandler.MEDIUM_MODEL)), 0.35f);
        this.tropicalFishBModel = new AquaTropicalFishBModel(context.bakeLayer(ModelLayers.TROPICAL_FISH_LARGE));
        this.smallModel = new FishSmallModel(context.bakeLayer(ClientHandler.SMALL_MODEL));
        this.mediumModel = new FishMediumModel(context.bakeLayer(ClientHandler.MEDIUM_MODEL));
        this.largeModel = new FishLargeModel(context.bakeLayer(ClientHandler.LARGE_MODEL));
        this.longnoseModel = new FishLongnoseModel(context.bakeLayer(ClientHandler.LONGNOSE_MODEL));
        this.catfishModel = new FishCathfishModel(context.bakeLayer(ClientHandler.CATFISH_MODEL));
        this.jellyfishModel = new JellyfishModel(context.bakeLayer(ClientHandler.JELLYFISH_MODEL));
    }

    @Nullable
    protected RenderType getRenderType(@Nonnull AquaFishRenderState renderState, boolean isVisible, boolean renderTranslucent, boolean appearsGlowing) {
        if (renderState.fishType == FishType.JELLYFISH) {
            return RenderType.entityTranslucent((ResourceLocation)JELLYFISH);
        }
        return super.getRenderType((LivingEntityRenderState)renderState, isVisible, renderTranslucent, appearsGlowing);
    }

    public void render(@Nonnull AquaFishRenderState renderState, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int i) {
        switch (renderState.fishType) {
            case SMALL: {
                this.model = this.smallModel;
                break;
            }
            case LARGE: {
                this.model = this.largeModel;
                break;
            }
            case LONGNOSE: {
                this.model = this.longnoseModel;
                break;
            }
            case CATFISH: {
                this.model = this.catfishModel;
                break;
            }
            case JELLYFISH: {
                this.model = this.jellyfishModel;
                break;
            }
            case HALIBUT: {
                this.model = this.tropicalFishBModel;
                break;
            }
            default: {
                this.model = this.mediumModel;
            }
        }
        super.render((LivingEntityRenderState)renderState, matrixStack, buffer, i);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull AquaFishRenderState renderState) {
        ResourceLocation location = renderState.byName;
        if (location != null) {
            return ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)("textures/entity/fish/" + location.getPath() + ".png"));
        }
        return DEFAULT_LOCATION;
    }

    protected void setupRotations(@Nonnull AquaFishRenderState renderState, @Nonnull PoseStack matrixStack, float partialTicks, float f) {
        super.setupRotations((LivingEntityRenderState)renderState, matrixStack, partialTicks, f);
        FishType fishType = renderState.fishType;
        if (fishType != FishType.JELLYFISH) {
            float salmonRotation = 1.0f;
            float salmonMultiplier = 1.0f;
            if (fishType == FishType.LONGNOSE && !renderState.isInWater) {
                salmonRotation = 1.3f;
                salmonMultiplier = 1.7f;
            }
            float fishRotation = fishType == FishType.LONGNOSE ? salmonRotation * 4.3f * Mth.sin((float)(salmonMultiplier * 0.6f * renderState.ageInTicks)) : 4.3f * Mth.sin((float)(0.6f * renderState.ageInTicks));
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(fishRotation));
            if (fishType == FishType.LONGNOSE) {
                matrixStack.translate(0.0f, 0.0f, -0.4f);
            }
            if (!renderState.isInWater && fishType != FishType.HALIBUT) {
                if (fishType == FishType.MEDIUM || fishType == FishType.LARGE || fishType == FishType.CATFISH) {
                    matrixStack.translate(0.1f, 0.1f, -0.1f);
                } else {
                    matrixStack.translate(0.2f, 0.1f, 0.0f);
                }
                matrixStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
            }
            if (fishType == FishType.HALIBUT) {
                matrixStack.translate(-0.4f, 0.1f, 0.0f);
                matrixStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-90.0f));
            }
        }
    }

    protected void scale(AquaFishRenderState renderState, @Nonnull PoseStack matrixStack) {
        ResourceLocation location = renderState.byName;
        float scale = 0.0f;
        if (location != null) {
            switch (location.getPath()) {
                case "minnow": {
                    scale = 0.5f;
                    break;
                }
                case "synodontis": {
                    scale = 0.8f;
                    break;
                }
                case "brown_trout": 
                case "piranha": {
                    scale = 0.9f;
                    break;
                }
                case "pollock": {
                    scale = 1.1f;
                    break;
                }
                case "atlantic_cod": 
                case "blackfish": 
                case "catfish": 
                case "tambaqui": {
                    scale = 1.2f;
                    break;
                }
                case "pacific_halibut": 
                case "atlantic_halibut": 
                case "capitaine": 
                case "largemouth_bass": 
                case "gar": 
                case "arapaima": 
                case "tuna": {
                    scale = 1.4f;
                }
            }
        }
        if (scale > 0.0f) {
            matrixStack.pushPose();
            matrixStack.scale(scale, scale, scale);
            matrixStack.popPose();
        }
    }

    @Nonnull
    public AquaFishRenderState createRenderState() {
        return new AquaFishRenderState();
    }

    public void extractRenderState(@Nonnull AquaFishEntity fishEntity, @Nonnull AquaFishRenderState renderState, float partialTicks) {
        super.extractRenderState((LivingEntity)fishEntity, (LivingEntityRenderState)renderState, partialTicks);
        renderState.fishType = fishEntity.getFishType();
        renderState.byName = fishEntity.byName();
    }
}

