/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.TurtleLandModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.state.TurtleLandRenderState;
import com.teammetallurgy.aquaculture.entity.TurtleLandEntity;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class TurtleLandRenderer
extends AgeableMobRenderer<TurtleLandEntity, TurtleLandRenderState, TurtleLandModel> {
    private static final ResourceLocation BOX_TURTLE = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/turtle/box_turtle.png");
    private static final ResourceLocation ARRAU_TURTLE = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/turtle/arrau_turtle.png");
    private static final ResourceLocation STARSHELL_TURTLE = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/turtle/starshell_turtle.png");

    public TurtleLandRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new TurtleLandModel(context.bakeLayer(ClientHandler.TURTLE_LAND_LAYER)), (EntityModel)new TurtleLandModel(context.bakeLayer(ClientHandler.TURTLE_LAND_BABY_LAYER)), 0.25f);
    }

    @Nonnull
    public TurtleLandRenderState createRenderState() {
        return new TurtleLandRenderState();
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull TurtleLandRenderState turtle) {
        if (((EntityType)AquaEntities.ARRAU_TURTLE.get()).equals(turtle.type)) {
            return ARRAU_TURTLE;
        }
        if (((EntityType)AquaEntities.STARSHELL_TURTLE.get()).equals(turtle.type)) {
            return STARSHELL_TURTLE;
        }
        return BOX_TURTLE;
    }

    public void extractRenderState(@Nonnull TurtleLandEntity turtle, @Nonnull TurtleLandRenderState renderState, float partialTick) {
        super.extractRenderState((LivingEntity)turtle, (LivingEntityRenderState)renderState, partialTick);
        renderState.type = turtle.getType();
    }
}

