/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.client.model.TackleBoxModel;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class TackleBoxSpecialRenderer
implements NoDataSpecialModelRenderer {
    public static final Material TACKLE_BOX_MATERIAL = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"block/tackle_box"));
    public static final ResourceLocation TACKLE_BOX = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"tackle_box");
    private final TackleBoxModel model;
    private final float angle;

    public TackleBoxSpecialRenderer(TackleBoxModel model, float angle) {
        this.model = model;
        this.angle = angle;
    }

    public void render(@Nonnull ItemDisplayContext displayContext, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean b) {
        VertexConsumer vertexconsumer = TACKLE_BOX_MATERIAL.buffer(bufferSource, RenderType::entitySolid);
        poseStack.pushPose();
        this.model.setupAnim(this.angle);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-Direction.NORTH.toYRot()));
        poseStack.translate(-1.0f, 1.125f, -0.5f);
        poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(-180.0f));
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public void getExtents(Set<Vector3f> output) {
        PoseStack posestack = new PoseStack();
        this.model.setupAnim(this.angle);
        this.model.root().getExtentsForGui(posestack, output);
    }

    public record Unbaked(float angle) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(r -> r.group((App)Codec.FLOAT.optionalFieldOf("angle", (Object)Float.valueOf(0.0f)).forGetter(Unbaked::angle)).apply((Applicative)r, Unbaked::new));

        public Unbaked() {
            this(0.0f);
        }

        @Nonnull
        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            TackleBoxModel tackleBoxModel = new TackleBoxModel(modelSet.bakeLayer(ClientHandler.TACKLE_BOX));
            return new TackleBoxSpecialRenderer(tackleBoxModel, this.angle);
        }
    }
}

