/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.inventory.container.slot;

import com.teammetallurgy.aquaculture.init.AquaDataComponents;
import com.teammetallurgy.aquaculture.inventory.container.slot.SlotFishingRod;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class SlotHidable
extends SlotItemHandler {
    private final SlotFishingRod fishingRod;

    public SlotHidable(SlotFishingRod fishingRod, int index, int xPosition, int yPosition) {
        super((IItemHandler)fishingRod.rodHandler, index, xPosition, yPosition);
        this.fishingRod = fishingRod;
    }

    @Nonnull
    public IItemHandler getItemHandler() {
        return this.fishingRod.rodHandler;
    }

    public boolean mayPlace(@Nonnull ItemStack stack) {
        return this.fishingRod.hasItem();
    }

    public boolean mayPickup(Player player) {
        return this.fishingRod.hasItem() && super.mayPickup(player);
    }

    public boolean isActive() {
        return this.fishingRod.hasItem();
    }

    public void setChanged() {
        ItemStack stack = this.fishingRod.getItem();
        if (!stack.isEmpty()) {
            NonNullList list = NonNullList.create();
            for (int slot = 0; slot < this.getItemHandler().getSlots(); ++slot) {
                list.add((Object)this.getItemHandler().getStackInSlot(slot));
            }
            stack.set(AquaDataComponents.ROD_INVENTORY, (Object)ItemContainerContents.fromItems((List)list));
        }
    }
}

