/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class AquaFishBucket
extends MobBucketItem {
    private final EntityType<?> fishType;

    public AquaFishBucket(EntityType<? extends Mob> entityType, Item.Properties properties) {
        super(entityType, (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, properties);
        this.fishType = entityType;
    }

    @Nonnull
    public InteractionResult use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResult.PASS;
        }
        BlockHitResult raytrace = AquaFishBucket.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (raytrace.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        BlockPos pos = raytrace.getBlockPos();
        if (!(world.getBlockState(pos).getBlock() instanceof LiquidBlock)) {
            return super.use(world, player, hand);
        }
        if (world.mayInteract((Entity)player, pos) && player.mayUseItemAt(pos, raytrace.getDirection(), heldStack)) {
            Entity fishEntity;
            if (world instanceof ServerLevel && (fishEntity = this.fishType.spawn((ServerLevel)world, heldStack, null, pos, EntitySpawnReason.BUCKET, true, false)) != null) {
                ((AbstractFish)fishEntity).setFromBucket(true);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResult.SUCCESS.heldItemTransformedTo(MobBucketItem.getEmptySuccessItem((ItemStack)heldStack, (Player)player));
        }
        return InteractionResult.FAIL;
    }
}

