/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammetallurgy.aquaculture.loot.BiomeTagPredicate;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;

public record BiomeTagCheck(Optional<BiomeTagPredicate> predicate) implements LootItemCondition
{
    public static final MapCodec<BiomeTagCheck> CODEC = RecordCodecBuilder.mapCodec(rb -> rb.group((App)BiomeTagPredicate.CODEC.optionalFieldOf("predicate").forGetter(BiomeTagCheck::predicate)).apply((Applicative)rb, BiomeTagCheck::new));
    public static final LootItemConditionType BIOME_TAG_CHECK = new LootItemConditionType(CODEC);

    public boolean test(LootContext context) {
        Vec3 pos = (Vec3)context.getOptionalParameter(LootContextParams.ORIGIN);
        return pos != null && this.predicate.isPresent() && this.predicate.get().matches(context.getLevel(), pos.x(), pos.y(), pos.z());
    }

    @Nonnull
    public LootItemConditionType getType() {
        return BIOME_TAG_CHECK;
    }
}

