/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks;

import com.teammetallurgy.atum.blocks.stone.limestone.BlockLimestoneBricks;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.utils.AtumConfig;
import com.teammetallurgy.atum.world.teleporter.AtumTeleporter;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPortal
extends BlockBreakable {
    private static final AxisAlignedBB PORTAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);

    public BlockPortal() {
        super(Material.field_151567_E, false);
        this.func_149675_a(true);
        this.func_149711_c(-1.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(0.75f);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PORTAL_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean trySpawnPortal(World world, BlockPos pos) {
        Size size = new Size(world, pos);
        if (size.isValid()) {
            size.placePortalBlocks();
            world.func_184133_a(null, pos, SoundEvents.field_193782_bq, SoundCategory.BLOCKS, 0.7f, 1.0f);
            return true;
        }
        Size size1 = new Size(world, pos);
        if (size1.isValid()) {
            size1.placePortalBlocks();
            world.func_184133_a(null, pos, SoundEvents.field_193782_bq, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        Size size = new Size(world, pos);
        if ((neighborBlock == this || size.isSandBlock(neighborBlock.func_176223_P())) && !size.isValid()) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity instanceof EntityPlayerMP && entity.field_71088_bW <= 0) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            int dimension = player.field_71093_bK == AtumConfig.DIMENSION_ID ? DimensionType.OVERWORLD.func_186068_a() : AtumConfig.DIMENSION_ID;
            BlockPortal.changeDimension(world, (EntityPlayerMP)entity, dimension, (ITeleporter)new AtumTeleporter(player.field_71133_b.func_71218_a(dimension)));
        }
    }

    public static void changeDimension(World world, EntityPlayerMP player, int dimension, ITeleporter teleporter) {
        if (!world.field_72995_K) {
            BlockPos playerPos;
            player.field_71088_bW = 300;
            player.changeDimension(dimension, teleporter);
            if (player.field_71093_bK == AtumConfig.DIMENSION_ID && world.func_175623_d(playerPos = new BlockPos((Entity)player)) && world.func_180495_p(playerPos).isSideSolid((IBlockAccess)world, playerPos, EnumFacing.UP)) {
                player.setSpawnChunk(playerPos, true, AtumConfig.DIMENSION_ID);
            }
        }
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public static class Size {
        private static final int MAX_SIZE = 9;
        private static final int MIN_SIZE = 3;
        private final World world;
        private boolean valid = false;
        private BlockPos nw;
        private BlockPos se;

        public Size(World world, BlockPos pos) {
            int y;
            this.world = world;
            int east = this.getDistanceUntilEdge(pos, EnumFacing.EAST);
            int west = this.getDistanceUntilEdge(pos, EnumFacing.WEST);
            int north = this.getDistanceUntilEdge(pos, EnumFacing.NORTH);
            int south = this.getDistanceUntilEdge(pos, EnumFacing.SOUTH);
            int width = east + west - 1;
            int length = north + south - 1;
            if (width > 9 || length > 9) {
                return;
            }
            if (width < 3 || length < 3) {
                return;
            }
            BlockPos neCorner = pos.func_177965_g(east).func_177964_d(north);
            BlockPos nwCorner = pos.func_177985_f(west).func_177964_d(north);
            BlockPos seCorner = pos.func_177965_g(east).func_177970_e(south);
            BlockPos swCorner = pos.func_177985_f(west).func_177970_e(south);
            this.nw = nwCorner.func_177982_a(1, 0, 1);
            this.se = seCorner.func_177982_a(-1, 0, -1);
            int wallWidth = width + 2;
            int wallLength = length + 2;
            for (y = 0; y <= 1; ++y) {
                for (int x = 0; x < wallWidth; ++x) {
                    for (int z = 0; z < wallLength; ++z) {
                        if (y != 0 && x != 0 && z != 0 && x != wallWidth - 1 && z != wallLength - 1 || this.isSandBlock(world.func_180495_p(nwCorner.func_177977_b().func_177982_a(x, y, z)))) continue;
                        return;
                    }
                }
            }
            for (y = 0; y < 2; ++y) {
                if (!this.isSandBlock(world.func_180495_p(neCorner.func_177982_a(0, y + 1, 0)))) {
                    return;
                }
                if (!this.isSandBlock(world.func_180495_p(nwCorner.func_177982_a(0, y + 1, 0)))) {
                    return;
                }
                if (!this.isSandBlock(world.func_180495_p(seCorner.func_177982_a(0, y + 1, 0)))) {
                    return;
                }
                if (this.isSandBlock(world.func_180495_p(swCorner.func_177982_a(0, y + 1, 0)))) continue;
                return;
            }
            this.valid = true;
        }

        int getDistanceUntilEdge(BlockPos pos, EnumFacing facing) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 9 && this.isEmptyBlock(this.world.func_180495_p(blockpos = pos.func_177967_a(facing, i))) && this.isSandBlock(this.world.func_180495_p(blockpos.func_177977_b())); ++i) {
            }
            IBlockState state = this.world.func_180495_p(pos.func_177967_a(facing, i));
            return this.isSandBlock(state) ? i : 0;
        }

        boolean isEmptyBlock(IBlockState state) {
            return state.func_185904_a() == Material.field_151586_h;
        }

        boolean isSandBlock(IBlockState state) {
            return state.func_177230_c() instanceof BlockSandStone || state.func_177230_c() instanceof BlockLimestoneBricks;
        }

        boolean isValid() {
            return this.valid;
        }

        void placePortalBlocks() {
            for (BlockPos.MutableBlockPos portalPos : BlockPos.MutableBlockPos.func_177975_b((BlockPos)this.nw, (BlockPos)this.se)) {
                this.world.func_180501_a((BlockPos)portalPos, AtumBlocks.PORTAL.func_176223_P(), 2);
            }
        }
    }
}

