/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.base;

import com.teammetallurgy.atum.blocks.base.tileentity.TileEntityChestBase;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity.TileEntitySarcophagus;
import com.teammetallurgy.atum.init.AtumBlocks;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;

public class BlockChestBase
extends BlockChest {
    private static final BlockChest.Type ATUM_CHEST_TYPE = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)String.valueOf(new ResourceLocation("atum", "chest")), (Class[])new Class[0], (Object[])new Object[0]);

    public BlockChestBase() {
        super(Objects.requireNonNull(ATUM_CHEST_TYPE));
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(3.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149647_a(null);
    }

    @Nonnull
    public Material func_149688_o(IBlockState state) {
        return Material.field_151576_e;
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        drops.add((Object)new ItemStack(AtumBlocks.LIMESTONE_CHEST));
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack(AtumBlocks.LIMESTONE_CHEST);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity instanceof TileEntityChestBase && !((TileEntityChestBase)tileEntity).canBeDouble ? field_185561_f : super.func_185496_a(state, world, pos);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(worldIn, pos, state, player);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (player.func_184812_l_() && tileEntity instanceof TileEntityChestBase) {
            this.func_180657_a(worldIn, player, pos, state, tileEntity, player.func_184614_ca());
        }
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity tileEntity, @Nonnull ItemStack stack) {
        if (!player.func_184812_l_()) {
            super.func_180657_a(world, player, pos, state, tileEntity, stack);
        }
        world.func_175698_g(pos);
        if (tileEntity instanceof TileEntityChestBase) {
            TileEntityChestBase chestBase = (TileEntityChestBase)tileEntity;
            if (chestBase.canBeDouble && !chestBase.canBeSingle) {
                for (EnumFacing horizontal : EnumFacing.field_176754_o) {
                    if (world.func_180495_p(pos.func_177972_a(horizontal)).func_177230_c() != this) continue;
                    this.breakDoubleChest(world, pos.func_177972_a(horizontal));
                }
            }
            chestBase.func_145843_s();
        }
    }

    private void breakDoubleChest(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityChestBase) {
            TileEntityChestBase chestBase = (TileEntityChestBase)tileEntity;
            if (!chestBase.func_191420_l()) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)chestBase);
            }
            world.func_175666_e(pos, (Block)this);
        }
        world.func_175698_g(pos);
    }

    public void func_176213_c(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        EnumFacing facing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityChestBase) {
            BlockPos posRight;
            boolean isEast;
            TileEntityChestBase chestBase = (TileEntityChestBase)tileEntity;
            state = state.func_177226_a((IProperty)field_176459_a, (Comparable)facing);
            BlockPos posNorth = pos.func_177978_c();
            BlockPos posSouth = pos.func_177968_d();
            BlockPos posWest = pos.func_177976_e();
            BlockPos posEast = pos.func_177974_f();
            boolean canBeDouble = chestBase.canBeDouble;
            boolean isNorth = this == world.func_180495_p(posNorth).func_177230_c() && canBeDouble;
            boolean isSouth = this == world.func_180495_p(posSouth).func_177230_c() && canBeDouble;
            boolean isWest = this == world.func_180495_p(posWest).func_177230_c() && canBeDouble;
            boolean bl = isEast = this == world.func_180495_p(posEast).func_177230_c() && canBeDouble;
            if (canBeDouble && !chestBase.canBeSingle && world.func_190527_a((Block)this, posRight = pos.func_177972_a(facing.func_176746_e().func_176734_d()), false, facing, null)) {
                BlockChestBase.setChestState(world, posRight, state);
            }
            if (!(isNorth || isSouth || isWest || isEast)) {
                world.func_180501_a(pos, state, 3);
            } else if (facing.func_176740_k() != EnumFacing.Axis.X || !isNorth && !isSouth) {
                if (facing.func_176740_k() == EnumFacing.Axis.Z && (isWest || isEast)) {
                    if (isWest) {
                        BlockChestBase.setChestState(world, posWest, state);
                    } else {
                        BlockChestBase.setChestState(world, posEast, state);
                    }
                    world.func_180501_a(pos, state, 3);
                }
            } else {
                if (isNorth) {
                    BlockChestBase.setChestState(world, posNorth, state);
                } else {
                    BlockChestBase.setChestState(world, posSouth, state);
                }
                world.func_180501_a(pos, state, 3);
            }
            if (stack.func_82837_s()) {
                chestBase.func_190575_a(stack.func_82833_r());
            }
        }
        this.func_176213_c(world, pos, state);
    }

    private static void setChestState(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        world.func_180501_a(pos, state, 3);
        if (tileEntity != null) {
            tileEntity.func_145829_t();
            world.func_175690_a(pos, tileEntity);
            if (tileEntity instanceof TileEntityChestBase) {
                ((TileEntityChestBase)tileEntity).field_145984_a = false;
            }
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing horizontal : EnumFacing.field_176754_o) {
            TileEntity tileOffset = world.func_175625_s(pos.func_177972_a(horizontal));
            if (!(tileOffset instanceof TileEntityChestBase)) continue;
            TileEntityChestBase chestOffset = (TileEntityChestBase)tileOffset;
            if (chestOffset.canBeDouble) continue;
            return true;
        }
        return super.func_176196_c(world, pos);
    }

    @Nullable
    public ILockableContainer func_189418_a(World world, @Nonnull BlockPos pos, boolean allowBlocking) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityChestBase)) {
            return null;
        }
        TileEntityChestBase lockableContainer = (TileEntityChestBase)tileEntity;
        if (!allowBlocking && this.isBlocked(world, pos)) {
            return null;
        }
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            TileEntityChestBase chestBase;
            BlockPos posFacing = pos.func_177972_a(facing);
            TileEntity tileOffset = world.func_175625_s(posFacing);
            Block block = world.func_180495_p(posFacing).func_177230_c();
            if (block != this || !(tileOffset instanceof TileEntityChestBase) || (chestBase = (TileEntityChestBase)tileOffset).func_145980_j() != ATUM_CHEST_TYPE || !chestBase.canBeDouble) continue;
            if (!allowBlocking && this.isBlocked(world, posFacing)) {
                return null;
            }
            String containerName = "container.chestDouble";
            if (lockableContainer instanceof TileEntitySarcophagus) {
                containerName = "atum.container.sarcophagus";
            }
            if (facing != EnumFacing.WEST && facing != EnumFacing.NORTH) {
                lockableContainer = new InventoryLargeChest(containerName, (ILockableContainer)lockableContainer, (ILockableContainer)((TileEntityChestBase)tileOffset));
                continue;
            }
            lockableContainer = new InventoryLargeChest(containerName, (ILockableContainer)((TileEntityChestBase)tileOffset), (ILockableContainer)lockableContainer);
        }
        return lockableContainer;
    }

    private boolean isBlocked(World world, BlockPos pos) {
        return this.isBelowSolidBlock(world, pos) || this.isOcelotSittingOnChest(world, pos);
    }

    private boolean isBelowSolidBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).isSideSolid((IBlockAccess)world, pos.func_177984_a(), EnumFacing.DOWN);
    }

    private boolean isOcelotSittingOnChest(World world, BlockPos pos) {
        for (Entity entity : world.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))) {
            EntityOcelot ocelot = (EntityOcelot)entity;
            if (!ocelot.func_70906_o()) continue;
            return true;
        }
        return false;
    }
}

