/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.linen;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.teammetallurgy.atum.utils.AtumRegistry;
import com.teammetallurgy.atum.utils.IOreDictEntry;
import com.teammetallurgy.atum.utils.OreDictHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.text.WordUtils;

public class BlockLinen
extends Block
implements IOreDictEntry {
    private static final Map<EnumDyeColor, Block> LINEN = Maps.newEnumMap(EnumDyeColor.class);

    public BlockLinen(Material material) {
        super(material);
        this.func_149711_c(0.6f);
        this.func_149672_a(SoundType.field_185854_g);
    }

    public static void registerLinenBlocks() {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            BlockLinen linen = new BlockLinen(Material.field_151580_n);
            LINEN.put(color, linen);
            AtumRegistry.registerBlock(linen, "linen_" + color.func_176610_l());
        }
    }

    public static Block getLinen(EnumDyeColor color) {
        return LINEN.get(color);
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.valueOf((String)this.getColorString().toUpperCase()));
    }

    public String getColorString() {
        Preconditions.checkNotNull((Object)this.getRegistryName(), (Object)"registryName");
        return this.getRegistryName().func_110623_a().replace("linen_", "");
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public void getOreDictEntries() {
        OreDictHelper.add(this, "wool");
        OreDictHelper.add(this, "wool" + WordUtils.capitalize((String)EnumDyeColor.valueOf((String)this.getColorString().toUpperCase()).func_176762_d()));
    }
}

