/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.linen;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.teammetallurgy.atum.blocks.linen.BlockLinen;
import com.teammetallurgy.atum.utils.AtumRegistry;
import com.teammetallurgy.atum.utils.OreDictHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLinenCarpet
extends BlockLinen {
    private static final Map<EnumDyeColor, Block> LINEN_CARPET = Maps.newEnumMap(EnumDyeColor.class);
    private static final AxisAlignedBB CARPET_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BlockLinenCarpet() {
        super(Material.field_151593_r);
        this.func_149711_c(0.1f);
    }

    public static void registerLinenCarpets() {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            BlockLinenCarpet linenCarpet = new BlockLinenCarpet();
            LINEN_CARPET.put(color, linenCarpet);
            AtumRegistry.registerBlock(linenCarpet, "linen_carpet_" + color.func_176610_l());
        }
    }

    public static Block getLinenBlock(EnumDyeColor color) {
        return LINEN_CARPET.get(color);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CARPET_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World world, @Nonnull BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canBlockStay(world, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkForDrop(worldIn, pos, state);
    }

    private boolean checkForDrop(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            return false;
        }
        return true;
    }

    private boolean canBlockStay(World world, BlockPos pos) {
        return !world.func_175623_d(pos.func_177977_b());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing facing) {
        if (facing == EnumFacing.UP) {
            return true;
        }
        return world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() == this || super.func_176225_a(state, world, pos, facing);
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Override
    public String getColorString() {
        Preconditions.checkNotNull((Object)this.getRegistryName(), (Object)"registryName");
        return this.getRegistryName().func_110623_a().replace("linen_carpet_", "");
    }

    @Override
    public void getOreDictEntries() {
        OreDictHelper.add(this, "carpet");
    }
}

