/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.machines;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.machines.BlockKilnFake;
import com.teammetallurgy.atum.blocks.machines.tileentity.TileEntityKiln;
import com.teammetallurgy.atum.blocks.machines.tileentity.TileEntityKilnBase;
import com.teammetallurgy.atum.blocks.stone.limestone.BlockLimestoneBricks;
import com.teammetallurgy.atum.init.AtumBlocks;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockKiln
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool IS_BURNING = PropertyBool.func_177716_a((String)"is_burning");
    static final PropertyBool MULTIBLOCK_PRIMARY = PropertyBool.func_177716_a((String)"multiblock_primary");
    private static final PropertyBool MULTIBLOCK_SECONDARY = PropertyBool.func_177716_a((String)"multiblock_secondary");

    public BlockKiln() {
        super(Material.field_151576_e, MapColor.field_151658_d);
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)IS_BURNING, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MULTIBLOCK_PRIMARY, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MULTIBLOCK_SECONDARY, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World world, int meta) {
        return new TileEntityKiln();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (world.field_72995_K) {
            return true;
        }
        BlockPos tepos = this.getPrimaryKilnBlock(world, pos);
        if (tepos != null && (tileEntity = world.func_175625_s(tepos)) instanceof TileEntityKiln) {
            player.openGui((Object)Atum.instance, 5, world, tepos.func_177958_n(), tepos.func_177956_o(), tepos.func_177952_p());
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)IS_BURNING) != false ? 13 : 0;
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)MULTIBLOCK_PRIMARY)).booleanValue()) {
            this.destroyMultiblock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
        } else {
            BlockPos primaryPos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176735_f());
            IBlockState primaryState = world.func_180495_p(primaryPos);
            if (primaryState.func_177230_c() == AtumBlocks.KILN && ((Boolean)primaryState.func_177229_b((IProperty)MULTIBLOCK_PRIMARY)).booleanValue()) {
                this.destroyMultiblock(world, primaryPos, (EnumFacing)primaryState.func_177229_b((IProperty)FACING));
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        TileEntity tileEntity;
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack.func_82837_s() && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityKiln) {
            ((TileEntityKiln)tileEntity).func_190575_a(stack.func_82833_r());
        }
        state = world.func_180495_p(pos);
        this.tryMakeMultiblock(world, pos, state);
    }

    public void tryMakeMultiblock(World world, BlockPos pos, IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (this.checkMultiblock(world, pos, facing)) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)MULTIBLOCK_PRIMARY, (Comparable)Boolean.valueOf(true)));
            world.func_175656_a(pos.func_177972_a(facing.func_176746_e()), state.func_177226_a((IProperty)MULTIBLOCK_PRIMARY, (Comparable)Boolean.valueOf(false)));
            this.createMultiblock(world, pos);
        } else if (this.checkMultiblock(world, pos.func_177972_a(facing.func_176735_f()), facing)) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)MULTIBLOCK_PRIMARY, (Comparable)Boolean.valueOf(false)));
            world.func_175656_a(pos.func_177972_a(facing.func_176735_f()), state.func_177226_a((IProperty)MULTIBLOCK_PRIMARY, (Comparable)Boolean.valueOf(true)));
            this.createMultiblock(world, pos.func_177972_a(facing.func_176735_f()));
        }
    }

    public static BlockPos getSecondaryKilnFromPrimary(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityKiln && state.func_177230_c() == AtumBlocks.KILN && ((TileEntityKiln)tileEntity).isPrimary()) {
            return pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e());
        }
        return null;
    }

    private BlockPos getPrimaryKilnBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == AtumBlocks.KILN && ((Boolean)state.func_177229_b((IProperty)MULTIBLOCK_PRIMARY)).booleanValue()) {
            return pos;
        }
        if ((state = world.func_180495_p(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176735_f()))).func_177230_c() == AtumBlocks.KILN && ((Boolean)state.func_177229_b((IProperty)MULTIBLOCK_PRIMARY)).booleanValue()) {
            return pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176735_f());
        }
        return null;
    }

    private void createMultiblock(World world, BlockPos primaryPos) {
        BlockPos secondaryPos;
        List<BlockPos> brickPositions = this.getKilnBrickPositions(primaryPos, (EnumFacing)world.func_180495_p(primaryPos).func_177229_b((IProperty)FACING));
        for (BlockPos brickPos : brickPositions) {
            world.func_175656_a(brickPos, AtumBlocks.KILN_FAKE.func_176223_P().func_177226_a((IProperty)BlockKilnFake.UP, (Comparable)Boolean.valueOf(primaryPos.func_177956_o() - 1 == brickPos.func_177956_o())));
            TileEntity tileEntity = world.func_175625_s(brickPos);
            if (tileEntity == null) continue;
            ((TileEntityKilnBase)tileEntity).setPrimaryPos(primaryPos);
        }
        TileEntity tileEntity = world.func_175625_s(primaryPos);
        if (tileEntity instanceof TileEntityKilnBase) {
            ((TileEntityKilnBase)tileEntity).setPrimaryPos(primaryPos);
        }
        if ((secondaryPos = BlockKiln.getSecondaryKilnFromPrimary(world, primaryPos)) != null && (tileEntity = world.func_175625_s(secondaryPos)) instanceof TileEntityKilnBase) {
            ((TileEntityKilnBase)tileEntity).setPrimaryPos(primaryPos);
        }
    }

    void destroyMultiblock(World world, BlockPos primaryPos, EnumFacing facing) {
        TileEntityKilnBase kilnBase;
        List<BlockPos> brickPositions = this.getKilnBrickPositions(primaryPos, facing);
        IBlockState primaryState = world.func_180495_p(primaryPos);
        BlockPos secondaryPos = primaryPos.func_177972_a(facing.func_176746_e());
        IBlockState secondaryState = world.func_180495_p(secondaryPos);
        BlockPos dropPos = primaryPos;
        if (primaryState.func_177230_c() == AtumBlocks.KILN) {
            world.func_175656_a(primaryPos, primaryState.func_177226_a((IProperty)MULTIBLOCK_PRIMARY, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)IS_BURNING, (Comparable)Boolean.valueOf(false)));
        }
        if (secondaryState.func_177230_c() == AtumBlocks.KILN) {
            world.func_175656_a(secondaryPos, secondaryState.func_177226_a((IProperty)IS_BURNING, (Comparable)Boolean.valueOf(false)));
        } else {
            dropPos = secondaryPos;
        }
        for (BlockPos brickPos : brickPositions) {
            if (world.func_180495_p(brickPos).func_177230_c() == AtumBlocks.KILN_FAKE) {
                world.func_175656_a(brickPos, BlockLimestoneBricks.getBrick(BlockLimestoneBricks.BrickType.SMALL).func_176223_P());
                continue;
            }
            dropPos = brickPos;
        }
        TileEntity tileEntity = world.func_175625_s(primaryPos);
        if (tileEntity instanceof TileEntityKilnBase) {
            kilnBase = (TileEntityKilnBase)tileEntity;
            kilnBase.setPrimaryPos(null);
            InventoryHelper.func_180175_a((World)world, (BlockPos)dropPos, (IInventory)kilnBase);
            kilnBase.func_145843_s();
        }
        if ((tileEntity = world.func_175625_s(secondaryPos)) instanceof TileEntityKilnBase) {
            kilnBase = (TileEntityKilnBase)tileEntity;
            kilnBase.setPrimaryPos(null);
        }
    }

    private boolean checkMultiblock(World world, BlockPos primaryPos, EnumFacing facing) {
        List<BlockPos> brickPositions = this.getKilnBrickPositions(primaryPos, facing);
        if (world.func_180495_p(primaryPos).func_177230_c() != AtumBlocks.KILN) {
            return false;
        }
        if (world.func_180495_p(primaryPos.func_177972_a(facing.func_176746_e())).func_177230_c() != AtumBlocks.KILN) {
            return false;
        }
        for (BlockPos brickPos : brickPositions) {
            IBlockState brickState = world.func_180495_p(brickPos);
            if (brickState.func_177230_c() == BlockLimestoneBricks.getBrick(BlockLimestoneBricks.BrickType.SMALL)) continue;
            return false;
        }
        return true;
    }

    private List<BlockPos> getKilnBrickPositions(BlockPos pos, EnumFacing facing) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        positions.add(pos.func_177972_a(EnumFacing.DOWN));
        positions.add(pos.func_177972_a(facing.func_176734_d()));
        positions.add(pos.func_177972_a(facing.func_176734_d()).func_177972_a(EnumFacing.DOWN));
        BlockPos offset = pos.func_177972_a(facing.func_176746_e());
        positions.add(offset.func_177972_a(EnumFacing.DOWN));
        positions.add(offset.func_177972_a(facing.func_176734_d()));
        positions.add(offset.func_177972_a(facing.func_176734_d()).func_177972_a(EnumFacing.DOWN));
        return positions;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityKiln kiln;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityKiln && this.getPrimaryKilnBlock((kiln = (TileEntityKiln)tileEntity).func_145831_w(), pos) != null) {
            return state.func_177226_a((IProperty)MULTIBLOCK_SECONDARY, (Comparable)Boolean.valueOf(!kiln.isPrimary()));
        }
        return state;
    }

    @Nonnull
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)MULTIBLOCK_PRIMARY, (Comparable)Boolean.valueOf(false));
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IS_BURNING, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)MULTIBLOCK_PRIMARY, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)IS_BURNING)).booleanValue()) {
            meta |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)MULTIBLOCK_PRIMARY)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, IS_BURNING, MULTIBLOCK_PRIMARY, MULTIBLOCK_SECONDARY});
    }
}

