/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.machines;

import com.teammetallurgy.atum.api.recipe.RecipeHandlers;
import com.teammetallurgy.atum.api.recipe.spinningwheel.ISpinningWheelRecipe;
import com.teammetallurgy.atum.blocks.machines.tileentity.TileEntitySpinningWheel;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.utils.StackHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSpinningWheel
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyInteger SPOOL = PropertyInteger.func_177719_a((String)"spool", (int)0, (int)3);
    private static final PropertyBool WHEEL = PropertyBool.func_177716_a((String)"wheel");

    public BlockSpinningWheel() {
        super(Material.field_151575_d);
        this.func_149711_c(1.2f);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)SPOOL, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)WHEEL, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World world, int meta) {
        return new TileEntitySpinningWheel();
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntitySpinningWheel) {
            TileEntitySpinningWheel spinningWheel = (TileEntitySpinningWheel)tileEntity;
            if (player.func_70093_af()) {
                StackHelper.giveItem(player, EnumHand.MAIN_HAND, spinningWheel.func_70301_a(0).func_77946_l());
                StackHelper.giveItem(player, EnumHand.MAIN_HAND, spinningWheel.func_70301_a(1).func_77946_l());
                spinningWheel.func_70298_a(0, spinningWheel.func_70297_j_());
                spinningWheel.func_70298_a(1, spinningWheel.func_70297_j_());
                spinningWheel.input = new NBTTagCompound();
                spinningWheel.rotations = 0;
                spinningWheel.wheel = false;
                world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)SPOOL, (Comparable)Integer.valueOf(0)), 2);
                spinningWheel.func_70296_d();
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        ItemStack heldStack = player.func_184586_b(hand);
        if (tileEntity instanceof TileEntitySpinningWheel) {
            TileEntitySpinningWheel spinningWheel = (TileEntitySpinningWheel)tileEntity;
            if (facing == state.func_177229_b((IProperty)FACING)) {
                this.output(world, pos, player, spinningWheel);
            } else if (facing == EnumFacing.UP) {
                if (spinningWheel.func_191420_l() && !heldStack.func_190926_b() && spinningWheel.func_94041_b(0, heldStack) && (Integer)state.func_177229_b((IProperty)SPOOL) < 3) {
                    ItemStack inputStack;
                    ItemStack copyStack = new ItemStack(heldStack.func_77973_b(), 1, heldStack.func_77960_j());
                    boolean canInsert = false;
                    if (spinningWheel.input.func_82582_d()) {
                        spinningWheel.input = copyStack.func_77955_b(new NBTTagCompound());
                    }
                    if (StackHelper.areStacksEqualIgnoreSize(inputStack = new ItemStack(spinningWheel.input), heldStack)) {
                        canInsert = true;
                    } else if (!inputStack.func_190926_b() && world.field_72995_K) {
                        player.func_146105_b(new TextComponentTranslation("chat.atum.spinningWheel.recipeInProgress", new Object[]{inputStack.func_82833_r()}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                        world.func_184133_a(player, new BlockPos((Entity)player), SoundEvents.field_187726_cu, SoundCategory.BLOCKS, 0.8f, 1.0f);
                    }
                    if (canInsert) {
                        spinningWheel.func_70299_a(0, copyStack);
                        if (!player.func_184812_l_()) {
                            heldStack.func_190918_g(1);
                        }
                        spinningWheel.func_70296_d();
                    }
                } else if (!spinningWheel.input.func_82582_d()) {
                    ItemStack input = new ItemStack(spinningWheel.input);
                    for (ISpinningWheelRecipe spinningWheelRecipe : RecipeHandlers.spinningWheelRecipes) {
                        if (!spinningWheelRecipe.isValidInput(input)) continue;
                        if (!spinningWheel.func_191420_l()) {
                            boolean bl = spinningWheel.wheel = !spinningWheel.wheel;
                        }
                        if (spinningWheelRecipe.getRotations() == spinningWheel.rotations && (Integer)state.func_177229_b((IProperty)SPOOL) < 3 && !spinningWheel.func_191420_l()) {
                            world.func_180501_a(pos, state.func_177231_a((IProperty)SPOOL), 2);
                            spinningWheel.func_70298_a(0, 1);
                            spinningWheel.rotations = 0;
                            spinningWheel.wheel = false;
                        } else if (!spinningWheel.wheel && (Integer)state.func_177229_b((IProperty)SPOOL) < 3 && !spinningWheel.func_191420_l()) {
                            ++spinningWheel.rotations;
                            if (world.field_72995_K) {
                                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187644_cT, SoundCategory.BLOCKS, 0.55f, 0.4f, true);
                            }
                        }
                        if ((Integer)state.func_177229_b((IProperty)SPOOL) != 3) continue;
                        ItemStack copyOutput = spinningWheelRecipe.getOutput();
                        ItemStack output = new ItemStack(copyOutput.func_77973_b(), copyOutput.func_190916_E(), copyOutput.func_77960_j());
                        spinningWheel.func_70299_a(1, output);
                        spinningWheel.input = new NBTTagCompound();
                    }
                    spinningWheel.func_70296_d();
                }
            }
        }
        return true;
    }

    public void output(World world, BlockPos pos, @Nullable EntityPlayer player, TileEntitySpinningWheel spinningWheel) {
        IBlockState state = world.func_180495_p(pos);
        if ((Integer)state.func_177229_b((IProperty)SPOOL) == 3) {
            if (!world.field_72995_K && player != null) {
                StackHelper.giveItem(player, EnumHand.MAIN_HAND, spinningWheel.func_70301_a(1));
                spinningWheel.func_70298_a(1, spinningWheel.func_70297_j_());
            }
            spinningWheel.input = new NBTTagCompound();
            spinningWheel.wheel = false;
            world.func_180501_a(pos, state.func_177231_a((IProperty)SPOOL), 2);
            spinningWheel.func_70296_d();
        }
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack(AtumBlocks.SPINNING_WHEEL);
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntitySpinningWheel) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
        }
        super.func_180663_b(world, pos, state);
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntitySpinningWheel) {
            return state.func_177226_a((IProperty)WHEEL, (Comparable)Boolean.valueOf(((TileEntitySpinningWheel)tileEntity).wheel));
        }
        return state;
    }

    @Nonnull
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)SPOOL, (Comparable)Integer.valueOf((meta & 0xF) >> 2));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        return meta |= (Integer)state.func_177229_b((IProperty)SPOOL) << 2;
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, SPOOL, WHEEL});
    }
}

