/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.ceramic;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.teammetallurgy.atum.utils.AtumRegistry;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockCeramic
extends Block {
    private static final Map<EnumDyeColor, Block> CERAMIC = Maps.newEnumMap(EnumDyeColor.class);

    public BlockCeramic() {
        super(Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public static void registerCeramicBlocks() {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            BlockCeramic ceramic = new BlockCeramic();
            CERAMIC.put(color, ceramic);
            AtumRegistry.registerBlock(ceramic, "ceramic_" + color.func_176610_l());
        }
    }

    public static Block getCeramicBlocks(EnumDyeColor color) {
        return CERAMIC.get(color);
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.valueOf((String)this.getColorString().toUpperCase()));
    }

    private String getColorString() {
        Preconditions.checkNotNull((Object)this.getRegistryName(), (Object)"registryName");
        return this.getRegistryName().func_110623_a().replace("ceramic_", "").replace("tile_", "");
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }
}

