/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.ceramic;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.teammetallurgy.atum.blocks.base.BlockAtumSlab;
import com.teammetallurgy.atum.items.ItemAtumSlab;
import com.teammetallurgy.atum.utils.AtumRegistry;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockCeramicSlab
extends BlockAtumSlab {
    private static final Map<EnumDyeColor, Block> CERAMIC_SLAB = Maps.newEnumMap(EnumDyeColor.class);

    public BlockCeramicSlab() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.field_149783_u = true;
    }

    public static void registerSlabs() {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            BlockCeramicSlab ceramicSlab = new BlockCeramicSlab();
            CERAMIC_SLAB.put(color, ceramicSlab);
            AtumRegistry.registerBlock((Block)ceramicSlab, (Item)new ItemAtumSlab(ceramicSlab, ceramicSlab), "ceramic_slab_" + color.func_176610_l());
        }
    }

    public static Block getSlab(EnumDyeColor color) {
        return CERAMIC_SLAB.get(color);
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.valueOf((String)this.getColorString().toUpperCase()));
    }

    private String getColorString() {
        Preconditions.checkNotNull((Object)this.getRegistryName(), (Object)"registryName");
        return this.getRegistryName().func_110623_a().replace("ceramic_", "").replace("_slab", "");
    }
}

