/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.trap;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.trap.tileentity.TileEntityTrap;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public abstract class BlockTrap
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private static final PropertyBool DISABLED = PropertyBool.func_177716_a((String)"disabled");

    public BlockTrap() {
        super(Material.field_151576_e, MapColor.field_151658_d);
        this.func_149711_c(1.5f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)DISABLED, (Comparable)Boolean.FALSE));
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity instanceof TileEntityTrap && ((TileEntityTrap)tileEntity).isInsidePyramid ? -1.0f : super.func_176195_g(state, world, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity instanceof TileEntityTrap && ((TileEntityTrap)tileEntity).isInsidePyramid ? 6000000.0f : super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean isToolEffective;
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        boolean bl = isToolEffective = ForgeHooks.isToolEffective((IBlockAccess)world, (BlockPos)pos, (ItemStack)player.func_184586_b(EnumHand.MAIN_HAND)) || ForgeHooks.isToolEffective((IBlockAccess)world, (BlockPos)pos, (ItemStack)player.func_184586_b(EnumHand.OFF_HAND));
        if (tileEntity instanceof TileEntityTrap) {
            TileEntityTrap trap = (TileEntityTrap)tileEntity;
            if (!trap.isInsidePyramid) {
                player.openGui((Object)Atum.instance, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return true;
            }
            if (trap.isInsidePyramid && isToolEffective && !((Boolean)state.func_177229_b((IProperty)DISABLED)).booleanValue()) {
                this.setDisabled(world, pos, state, (TileEntityTrap)tileEntity, true);
                world.func_184133_a(null, pos, SoundEvents.field_187576_at, SoundCategory.BLOCKS, 1.1f, 1.5f);
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityTrap && !((TileEntityTrap)tileEntity).isInsidePyramid) {
            if (world.func_175640_z(pos)) {
                this.setDisabled(world, pos, state, (TileEntityTrap)tileEntity, true);
            } else if (!world.func_175640_z(pos)) {
                world.func_175684_a(pos, (Block)this, 4);
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityTrap && !((TileEntityTrap)tileEntity).isInsidePyramid && !world.func_175640_z(pos)) {
            this.setDisabled(world, pos, state, (TileEntityTrap)tileEntity, false);
        }
    }

    private void setDisabled(World world, BlockPos pos, IBlockState state, TileEntityTrap trap, boolean disabledStatus) {
        trap.setDisabledStatus(disabledStatus);
        world.func_175656_a(pos, state.func_177226_a((IProperty)DISABLED, (Comparable)Boolean.valueOf(disabledStatus)));
        world.func_184138_a(pos, state, state, 3);
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.setDefaultDirection(world, pos, state);
    }

    private void setDefaultDirection(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            boolean isNorth = world.func_180495_p(pos.func_177978_c()).func_185913_b();
            boolean isSouth = world.func_180495_p(pos.func_177968_d()).func_185913_b();
            if (facing == EnumFacing.NORTH && isNorth && !isSouth) {
                facing = EnumFacing.SOUTH;
            } else if (facing == EnumFacing.SOUTH && isSouth && !isNorth) {
                facing = EnumFacing.NORTH;
            } else {
                boolean isWest = world.func_180495_p(pos.func_177976_e()).func_185913_b();
                boolean isEast = world.func_180495_p(pos.func_177974_f()).func_185913_b();
                if (facing == EnumFacing.WEST && isWest && !isEast) {
                    facing = EnumFacing.EAST;
                } else if (facing == EnumFacing.EAST && isEast && !isWest) {
                    facing = EnumFacing.WEST;
                }
            }
            world.func_180501_a(pos, state.func_177230_c().func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing), 2);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)), 2);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityTrap) {
            ((TileEntityTrap)tileentity).isInsidePyramid = false;
            if (stack.func_82837_s()) {
                ((TileEntityTrap)tileentity).func_190575_a(stack.func_82833_r());
            }
        }
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityTrap) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileEntityTrap)tileentity));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)DISABLED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)DISABLED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, DISABLED});
    }
}

