/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.trap.tileentity;

import com.teammetallurgy.atum.blocks.trap.BlockTrap;
import com.teammetallurgy.atum.blocks.trap.tileentity.TileEntityTrap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class TileEntityArrowTrap
extends TileEntityTrap {
    private int timer = 80;

    @Override
    public void func_73660_a() {
        boolean isBurningCheck = this.isBurning();
        boolean isBurning = false;
        boolean canDamageEntity = false;
        if (this.timer > 0) {
            --this.timer;
        }
        if (!this.isDisabled && this.isBurning()) {
            EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTrap.FACING);
            Class entity = this.isInsidePyramid ? EntityPlayer.class : EntityLivingBase.class;
            AxisAlignedBB box = this.getFacingBoxWithRange(facing, 13).func_186664_h(1.0);
            RayTraceResult findBlock = this.rayTraceMinMax(this.field_145850_b, box);
            List entities = this.field_145850_b.func_72872_a(entity, box);
            for (EntityLivingBase livingBase : entities) {
                boolean cantSeeEntity;
                boolean bl = cantSeeEntity = findBlock != null && this.getDistance(findBlock.func_178782_a()) < this.getDistance(livingBase.func_180425_c());
                if (livingBase instanceof EntityPlayer ? !((EntityPlayer)livingBase).field_71075_bZ.field_75098_d && !cantSeeEntity : livingBase != null && !cantSeeEntity) {
                    canDamageEntity = true;
                    if (this.timer != 0) continue;
                    this.timer = 80;
                    this.spawnParticles(facing, livingBase);
                    this.fire(livingBase);
                    continue;
                }
                canDamageEntity = false;
            }
        }
        if (this.isInsidePyramid) {
            this.burnTime = 1;
        }
        if (this.isBurning() && !this.isDisabled && canDamageEntity && !this.isInsidePyramid) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K && !this.isDisabled) {
            ItemStack fuel = (ItemStack)this.inventory.get(0);
            if (!(!this.isBurning() && fuel.func_190926_b() || this.isBurning())) {
                this.currentItemBurnTime = this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)fuel) / 10;
                if (this.isBurning()) {
                    isBurning = true;
                    if (!fuel.func_190926_b()) {
                        fuel.func_190918_g(1);
                    }
                }
            }
            if (isBurningCheck != this.isBurning()) {
                isBurning = true;
            }
        }
        if (isBurning) {
            this.func_70296_d();
        }
    }

    private RayTraceResult rayTraceMinMax(World world, AxisAlignedBB box) {
        Vec3d min = new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72339_c);
        Vec3d max = new Vec3d(box.field_72336_d, box.field_72337_e + 0.05, box.field_72334_f);
        return world.func_147447_a(max, min, true, true, false);
    }

    private double getDistance(BlockPos position) {
        double d0 = position.func_177958_n() - this.field_174879_c.func_177958_n();
        double d1 = position.func_177956_o() - this.field_174879_c.func_177956_o();
        double d2 = position.func_177952_p() - this.field_174879_c.func_177952_p();
        return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
    }

    @Override
    protected void spawnParticles(EnumFacing facing, EntityLivingBase livingBase) {
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble() * 12.0 / 16.0;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        double randomPos = this.field_145850_b.field_73012_v.nextDouble() * 0.6 - 0.3;
        this.field_145850_b.func_184134_a(x, (double)this.field_174879_c.func_177956_o(), z, SoundEvents.field_187578_au, SoundCategory.BLOCKS, 1.0f, 1.2f, false);
        switch (facing) {
            case DOWN: {
                this.fireArrow(this.field_145850_b, facing, x - randomPos, y - 0.5, z);
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x - randomPos, y - 0.2, z, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case UP: {
                this.fireArrow(this.field_145850_b, facing, x - randomPos, y + 1.0, z);
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x - randomPos, y + 1.0, z, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case WEST: {
                this.fireArrow(this.field_145850_b, facing, x - 0.52, y, z + randomPos);
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x - 0.52, y, z + randomPos, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case EAST: {
                this.fireArrow(this.field_145850_b, facing, x + 0.52, y, z + randomPos);
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + 0.52, y, z + randomPos, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case NORTH: {
                this.fireArrow(this.field_145850_b, facing, x + randomPos, y, z - 0.52);
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + randomPos, y, z - 0.52, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case SOUTH: {
                this.fireArrow(this.field_145850_b, facing, x + randomPos, y, z + 0.52);
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + randomPos, y, z + 0.52, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    private void fireArrow(World world, EnumFacing facing, double x, double y, double z) {
        if (!world.field_72995_K) {
            EntityTippedArrow arrow = new EntityTippedArrow(world, x, y, z);
            arrow.func_70186_c((double)facing.func_82601_c(), (double)((float)facing.func_96559_d() + 0.1f), (double)facing.func_82599_e(), 1.1f, 6.0f);
            world.func_72838_d((Entity)arrow);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.timer = compound.func_74762_e("Timer");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Timer", this.timer);
        return compound;
    }
}

