/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.trap.tileentity;

import com.teammetallurgy.atum.blocks.base.tileentity.TileEntityInventoryBase;
import com.teammetallurgy.atum.blocks.trap.BlockTrap;
import com.teammetallurgy.atum.inventory.container.block.ContainerTrap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTrap
extends TileEntityInventoryBase
implements ITickable {
    int burnTime;
    int currentItemBurnTime;
    boolean isDisabled = false;
    public boolean isInsidePyramid = true;

    public TileEntityTrap() {
        super(1);
    }

    public void setDisabledStatus(boolean isDisabled) {
        this.isDisabled = isDisabled;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    AxisAlignedBB getFacingBoxWithRange(EnumFacing facing, int range) {
        BlockPos pos = this.func_174877_v();
        EnumFacing.Axis axis = facing.func_176740_k();
        EnumFacing.AxisDirection dir = facing.func_176743_c();
        return new AxisAlignedBB(pos).func_72321_a(axis == EnumFacing.Axis.X ? (dir == EnumFacing.AxisDirection.POSITIVE ? (double)range : (double)(-range)) : 0.0, axis == EnumFacing.Axis.Y ? (dir == EnumFacing.AxisDirection.POSITIVE ? (double)range : (double)(-range)) : 0.0, axis == EnumFacing.Axis.Z ? (dir == EnumFacing.AxisDirection.POSITIVE ? (double)range : (double)(-range)) : 0.0);
    }

    public void func_73660_a() {
        boolean isBurningCheck = this.isBurning();
        boolean isBurning = false;
        boolean canDamageEntity = false;
        if (!this.isDisabled && this.isBurning()) {
            EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTrap.FACING);
            Class entity = this.isInsidePyramid ? EntityPlayer.class : EntityLivingBase.class;
            List entities = this.field_145850_b.func_72872_a(entity, this.getFacingBoxWithRange(facing, 1));
            for (EntityLivingBase livingBase : entities) {
                if (livingBase instanceof EntityPlayer ? !((EntityPlayer)livingBase).field_71075_bZ.field_75098_d : livingBase != null) {
                    canDamageEntity = true;
                    this.spawnParticles(facing, livingBase);
                    this.fire(livingBase);
                    continue;
                }
                canDamageEntity = false;
            }
        }
        if (this.isInsidePyramid) {
            this.burnTime = 1;
        }
        if (this.isBurning() && !this.isDisabled && canDamageEntity && !this.isInsidePyramid) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K && !this.isDisabled) {
            ItemStack fuel = (ItemStack)this.inventory.get(0);
            if (!(!this.isBurning() && fuel.func_190926_b() || this.isBurning())) {
                this.currentItemBurnTime = this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)fuel) / 10;
                if (this.isBurning()) {
                    isBurning = true;
                    if (!fuel.func_190926_b()) {
                        fuel.func_190918_g(1);
                    }
                }
            }
            if (isBurningCheck != this.isBurning()) {
                isBurning = true;
            }
        }
        if (isBurning) {
            this.func_70296_d();
        }
    }

    protected void spawnParticles(EnumFacing facing, EntityLivingBase livingBase) {
    }

    protected void fire(EntityLivingBase livingBase) {
    }

    boolean isBurning() {
        return this.burnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return super.func_70300_a(player) && !this.isInsidePyramid;
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        ItemStack fuel = (ItemStack)this.inventory.get(0);
        return !this.isInsidePyramid && (TileEntityFurnace.func_145954_b((ItemStack)stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && fuel.func_77973_b() != Items.field_151133_ar);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.burnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.burnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    @Nonnull
    public Container func_174876_a(@Nonnull InventoryPlayer playerInventory, @Nonnull EntityPlayer player) {
        return new ContainerTrap(playerInventory, (IInventory)this);
    }

    @Nonnull
    public String func_174875_k() {
        return String.valueOf(new ResourceLocation("atum", "trap"));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        super.onDataPacket(manager, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.burnTime = compound.func_74762_e("BurnTime");
        this.isDisabled = compound.func_74767_n("Disabled");
        this.isInsidePyramid = compound.func_74767_n("InPyramid");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", (int)((short)this.burnTime));
        compound.func_74757_a("Disabled", this.isDisabled);
        compound.func_74757_a("InPyramid", this.isInsidePyramid);
        return compound;
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return !this.isInsidePyramid ? super.func_70298_a(index, count) : ItemStack.field_190927_a;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return !this.isInsidePyramid && super.hasCapability(capability, facing);
    }
}

