/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.vegetation;

import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class BlockAnputsFingers
extends BlockCrops {
    private static final PropertyInteger ANPUTS_FINGERS_AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    private static final AxisAlignedBB[] AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0)};
    private HashMap<UUID, Integer> lastTouchedTick = new HashMap();

    @Nonnull
    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.field_151670_w;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB[this.func_185527_x(state)];
    }

    @Nonnull
    protected Item func_149866_i() {
        return AtumItems.ANPUTS_FINGERS_SPORES;
    }

    @Nonnull
    protected Item func_149865_P() {
        return AtumItems.ANPUTS_FINGERS_SPORES;
    }

    @Nonnull
    protected PropertyInteger func_185524_e() {
        return ANPUTS_FINGERS_AGE;
    }

    public int func_185526_g() {
        return 3;
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == AtumBlocks.SAND;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.func_180671_f(world, pos, this.func_176223_P());
    }

    public void func_180650_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        int age = this.func_185527_x(state);
        if (age < this.func_185526_g() && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (rand.nextInt(8) == 0 ? 1 : 0) != 0)) {
            IBlockState newState = state.func_177226_a((IProperty)this.func_185524_e(), (Comparable)Integer.valueOf(age + 1));
            world.func_180501_a(pos, newState, 2);
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)newState);
        }
        this.func_176475_e(world, pos, state);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            MinecraftServer server = world.func_73046_m();
            Integer lastTouched = this.lastTouchedTick.get(player.func_110124_au());
            if (server != null) {
                if (lastTouched != null && server.func_71259_af() - lastTouched < 35) {
                    return;
                }
                if (player.func_71024_bL().func_75116_a() > 0) {
                    player.func_71024_bL().func_75122_a(-1, -0.1f);
                    this.lastTouchedTick.put(player.func_110124_au(), server.func_71259_af());
                }
            }
        }
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
        return world.func_175642_b(EnumSkyBlock.SKY, pos) < 15 && stateDown.func_177230_c().canSustainPlant(stateDown, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public boolean func_176473_a(World world, BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ANPUTS_FINGERS_AGE});
    }
}

